/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.compat.rei.category;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.beachparty.core.compat.rei.display.PalmBarDisplay;
import net.satisfy.beachparty.core.registry.ObjectRegistry;

public class PalmBarCategory
implements DisplayCategory<PalmBarDisplay> {
    public static final CategoryIdentifier<PalmBarDisplay> PALM_BAR_DISPLAY = CategoryIdentifier.of((String)"beachparty", (String)"palm_bar_display");

    public CategoryIdentifier<PalmBarDisplay> getCategoryIdentifier() {
        return PALM_BAR_DISPLAY;
    }

    public Component getTitle() {
        return ((Block)ObjectRegistry.PALM_BAR.get()).m_49954_();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.PALM_BAR.get()));
    }

    public int getDisplayWidth(PalmBarDisplay display) {
        return 128;
    }

    public int getDisplayHeight() {
        return 80;
    }

    public List<Widget> setupDisplay(PalmBarDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - this.getDisplayWidth(display) / 2 - 4, bounds.getCenterY() - this.getDisplayHeight() / 2 + 26);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 62, startPoint.y + 9)).animationDurationTicks(50.0));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 96, startPoint.y + 9)));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 96, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        for (int i = 0; i < 4; ++i) {
            int yOffset = i % 2 * 20;
            int xOffset = i / 2 * 20;
            Point slotPos = new Point(startPoint.x + 20 + xOffset, startPoint.y + yOffset);
            if (i < display.getInputEntries().size()) {
                widgets.add(Widgets.createSlot((Point)slotPos).entries((Collection)display.getInputEntries().get(i)).markInput());
                continue;
            }
            widgets.add(Widgets.createSlotBackground((Point)slotPos));
        }
        return widgets;
    }
}

