/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PalmChairBlock
extends Block {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_LOWER = PalmChairBlock.makeLowerShape();
    public static final Map<Direction, VoxelShape> SHAPE_LOWER_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_LOWER));
        }
    });
    private static final VoxelShape SHAPE_UPPER = PalmChairBlock.makeUpperShape();
    public static final Map<Direction, VoxelShape> SHAPE_UPPER_MAP = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, BeachpartyUtil.rotateShape(Direction.NORTH, direction, SHAPE_UPPER));
        }
    });

    public PalmChairBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    private static VoxelShape makeLowerShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.5625, (double)0.1875, (double)0.8125, (double)0.625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.5625, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.3125, (double)0.5625, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.5625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.625, (double)0.6875, (double)0.8125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.625, (double)0.6875, (double)0.3125, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.5, (double)0.25, (double)0.75, (double)0.5625, (double)0.75), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.625, (double)0.71875, (double)0.6875, (double)1.0, (double)0.78125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    private static VoxelShape makeUpperShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.6875, (double)0.3125, (double)0.3125, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.6875, (double)0.8125, (double)0.3125, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.71875, (double)0.6875, (double)0.3125, (double)0.78125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockPos abovePos = blockPos.m_7494_();
        level.m_7731_(abovePos, (BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_((Property)FACING, (Comparable)((Direction)blockState.m_61143_((Property)FACING))), 3);
        super.m_6402_(level, blockPos, blockState, livingEntity, itemStack);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.UPPER) {
            return super.m_7898_(state, world, pos);
        }
        BlockState belowState = world.m_8055_(pos.m_7495_());
        return belowState.m_60713_((Block)this) && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        return pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(pos.m_7494_()).m_60629_(context) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return BeachpartyUtil.onUse(world, player, hand, hit, 0.25);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos abovePos = pos.m_7494_();
                BlockState aboveState = world.m_8055_(abovePos);
                if (aboveState.m_60734_() == this && aboveState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                    world.m_7731_(abovePos, Blocks.f_50016_.m_49966_(), 35);
                }
            } else {
                BlockPos belowPos = pos.m_7495_();
                BlockState belowState = world.m_8055_(belowPos);
                if (belowState.m_60734_() == this && belowState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                    world.m_7731_(belowPos, Blocks.f_50016_.m_49966_(), 35);
                }
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? SHAPE_UPPER_MAP.get(state.m_61143_((Property)FACING)) : SHAPE_LOWER_MAP.get(state.m_61143_((Property)FACING));
    }
}

