/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.gui.handler.slot.PalmBarOutputSlot;
import net.satisfy.beachparty.core.registry.ScreenHandlerTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class PalmBarGuiHandler
extends AbstractContainerMenu {
    protected final ContainerData propertyDelegate;

    public PalmBarGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(2));
    }

    public PalmBarGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerTypesRegistry.PALM_BAR_GUI_HANDLER.get(), syncId);
        this.propertyDelegate = propertyDelegate;
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
        this.m_38884_(propertyDelegate);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.m_38897_(new PalmBarOutputSlot(playerInventory.f_35978_, inventory, 0, 116, 35));
        this.m_38897_(new Slot(inventory, 1, 38, 25));
        this.m_38897_(new Slot(inventory, 2, 56, 25));
        this.m_38897_(new Slot(inventory, 3, 38, 43));
        this.m_38897_(new Slot(inventory, 4, 56, 43));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getShakeXProgress() {
        int progress = this.propertyDelegate.m_6413_(0);
        int totalProgress = this.propertyDelegate.m_6413_(1);
        if (totalProgress == 0 || progress == 0) {
            return 0;
        }
        return progress * 22 / totalProgress + 1;
    }

    @NotNull
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            ItemStack copyStack = originalStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(originalStack, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(originalStack, copyStack);
            } else if (index >= 1 && index <= 4 ? !this.m_38903_(originalStack, 5, 41, false) : index >= 5 && !this.m_38903_(originalStack, 1, 5, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (originalStack.m_41613_() == copyStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, originalStack);
            return copyStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }
}

