/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.cristelknight.doapi.client.ClientUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.satisfy.bakery.block.StoveBlock;
import net.satisfy.bakery.block.entity.StoveBlockEntity;

public class StoveBlockRenderer
implements BlockEntityRenderer<StoveBlockEntity> {
    public StoveBlockRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(StoveBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Direction direction = (Direction)blockEntity.m_58900_().m_61143_((Property)StoveBlock.FACING);
        Vec3 baseOffset = new Vec3(0.5, 1.0, 0.5);
        Vec3 directionOffset = Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(0.3);
        double rightOffset = 0.125;
        double downOffset = -0.48124999999999996;
        double inputSlotOffsetX = 0.0;
        double inputSlotOffsetY = 0.0;
        double inputSlotOffsetZ = 0.0;
        if (direction == Direction.NORTH) {
            inputSlotOffsetX = rightOffset;
            inputSlotOffsetY = downOffset;
            inputSlotOffsetZ = 0.15;
        } else if (direction == Direction.SOUTH) {
            inputSlotOffsetX = -rightOffset;
            inputSlotOffsetY = downOffset;
            inputSlotOffsetZ = -0.15;
        } else if (direction == Direction.EAST) {
            inputSlotOffsetX = -0.15;
            inputSlotOffsetY = downOffset;
            inputSlotOffsetZ = rightOffset;
        } else if (direction == Direction.WEST) {
            inputSlotOffsetX = 0.15;
            inputSlotOffsetY = downOffset;
            inputSlotOffsetZ = -rightOffset;
        }
        double ySpacing = 0.02;
        int slotIndex = 0;
        int numberOfSlots = blockEntity.getIngredientSlots().length;
        for (int slot : blockEntity.getIngredientSlots()) {
            ItemStack stack = blockEntity.m_8020_(slot);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            double yOffset = baseOffset.f_82480_ + downOffset + ySpacing * (double)(numberOfSlots - slotIndex - 1);
            poseStack.m_85837_(baseOffset.f_82479_ + directionOffset.f_82479_ + inputSlotOffsetX, yOffset, baseOffset.f_82481_ + directionOffset.f_82481_ + inputSlotOffsetZ);
            float rotationAngle = 45.0f * (float)(numberOfSlots - slotIndex - 1);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationAngle));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            ClientUtil.renderItem((ItemStack)stack, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockEntity)blockEntity);
            poseStack.m_85849_();
            ++slotIndex;
        }
        ItemStack outputStack = blockEntity.m_8020_(blockEntity.getOutputSlot());
        if (!outputStack.m_41619_()) {
            double outputSlotOffsetX = 0.0;
            double outputSlotOffsetY = 0.0;
            double outputSlotOffsetZ = 0.0;
            if (direction == Direction.NORTH) {
                outputSlotOffsetX = -0.15;
                outputSlotOffsetY = -0.49;
                outputSlotOffsetZ = 0.15;
            } else if (direction == Direction.SOUTH) {
                outputSlotOffsetX = 0.15;
                outputSlotOffsetY = -0.49;
                outputSlotOffsetZ = -0.15;
            } else if (direction == Direction.EAST) {
                outputSlotOffsetX = -0.15;
                outputSlotOffsetY = -0.49;
                outputSlotOffsetZ = -0.15;
            } else if (direction == Direction.WEST) {
                outputSlotOffsetX = 0.15;
                outputSlotOffsetY = -0.49;
                outputSlotOffsetZ = 0.15;
            }
            poseStack.m_85836_();
            poseStack.m_85837_(baseOffset.f_82479_ + directionOffset.f_82479_ + outputSlotOffsetX, baseOffset.f_82480_ + directionOffset.f_82480_ + outputSlotOffsetY, baseOffset.f_82481_ + directionOffset.f_82481_ + outputSlotOffsetZ);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.3f, 0.3f, 0.3f);
            ClientUtil.renderItem((ItemStack)outputStack, (PoseStack)poseStack, (MultiBufferSource)bufferSource, (BlockEntity)blockEntity);
            poseStack.m_85849_();
        }
    }
}

