/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.block.storage;

import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.block.storage.CakeStandBlock;
import net.satisfy.bakery.registry.StorageTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class TrayBlock
extends CakeStandBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0, (double)0.1875, (double)0.75, (double)0.0625, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0625, (double)0.125, (double)0.8125, (double)0.3125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0625, (double)0.125, (double)0.25, (double)0.3125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0625, (double)0.8125, (double)0.75, (double)0.3125, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.0625, (double)0.125, (double)0.75, (double)0.3125, (double)0.1875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)0.33375, (double)-0.121875, (double)0.6875, (double)0.33375, (double)0.003125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.3125, (double)-0.04625, (double)0.928125, (double)0.6875, (double)-0.04625, (double)1.053125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public TrayBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    @Override
    public int size() {
        return 5;
    }

    @Override
    public ResourceLocation type() {
        return StorageTypeRegistry.TRAY;
    }

    @Override
    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    @Override
    public int getSection(Float f, Float y) {
        float oneS = 0.11111111f;
        int nSection = (int)(f.floatValue() / oneS);
        return 8 - nSection;
    }
}

