/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideEscalatorSideBlock;

public class NarrowEscalatorBlock
extends AbstractWalkwayBlock {
    public NarrowEscalatorBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SLOPE, (Comparable)((Object)WalkwaySlope.HORIZONTAL)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SLOPE});
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return (WalkwaySlope)((Object)state.m_61143_((Property)SLOPE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.m_61143_((Property)SLOPE));
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.NARROW_ESCALATOR_BOTTOM.get(facing);
            case WalkwaySlope.TOP -> EscalatedShapes.NARROW_ESCALATOR_TOP.get(facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.NARROW_ESCALATOR_MIDDLE.get(facing);
            default -> EscalatedShapes.NARROW_WALKWAY.get(facing);
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.m_61143_((Property)SLOPE));
        if (slope == WalkwaySlope.HORIZONTAL || slope == WalkwaySlope.TERMINAL) {
            return super.m_5939_(state, blockGetter, pos, context);
        }
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        WalkwayBlockEntity be = (WalkwayBlockEntity)this.getBlockEntity(blockGetter, pos);
        if (be == null) {
            return super.m_5939_(state, blockGetter, pos, context);
        }
        float visualOffset = be.getVisualProgress();
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.NARROW_ESCALATOR_BOTTOM_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.NARROW_ESCALATOR_MIDDLE_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.TOP -> EscalatedShapes.NARROW_ESCALATOR_TOP_STEPPED.getShape(visualOffset, facing);
            default -> super.m_5939_(state, blockGetter, pos, context);
        };
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return false;
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        return (BlockState)((BlockState)((BlockState)this.getWalkwaySet().getWideSideBlock(level, state, pos).m_61124_(HORIZONTAL_FACING, (Comparable)((Direction)state.m_61143_(HORIZONTAL_FACING)))).m_61124_((Property)WideEscalatorSideBlock.LEFT, (Comparable)Boolean.valueOf(!left))).m_61124_((Property)SLOPE, (Comparable)((Object)((WalkwaySlope)((Object)state.m_61143_((Property)SLOPE)))));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        return true;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }
}

