/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.tool.modifiers.Combat;

import com.c2h6s.etstlib.EtSTLib;
import com.c2h6s.etstlib.register.EtSTLibHooks;
import com.c2h6s.etstlib.tool.hooks.ItemFoilModifierHook;
import com.c2h6s.etstlib.tool.modifiers.base.EtSTBaseModifier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class StaticDischarge
extends EtSTBaseModifier
implements ItemFoilModifierHook,
BlockBreakModifierHook {
    public static int CFG_CHARGE_REQUIRED = 3;
    public static float CFG_CHARGE_ATTACK_MUL = 2.0f;
    public static int CFG_CHARGE_ATTACK_EFFECT_LEVEL = 2;
    public static int CFG_CHARGE_ATTACK_EFFECT_TICKS = 50;
    public static final ResourceLocation KEY_STATIC_ELECTRICITY = EtSTLib.getResourceLocation("static_electricity");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook((Object)this, EtSTLibHooks.ITEM_FOIL, ModifierHooks.BLOCK_BREAK);
    }

    @Override
    public boolean hasFoil(IToolStackView tool, ModifierEntry entry) {
        return StaticDischarge.isStaticReady(tool);
    }

    public static boolean isStaticReady(IToolStackView tool) {
        return tool.getPersistentData().getInt(KEY_STATIC_ELECTRICITY) >= CFG_CHARGE_REQUIRED;
    }

    public static void releaseStatic(IToolStackView tool, ModifierEntry entry, @NotNull LivingEntity user) {
        if (user.m_9236_().f_46443_) {
            return;
        }
        tool.getPersistentData().remove(KEY_STATIC_ELECTRICITY);
        user.m_7292_(new MobEffectInstance(MobEffects.f_19598_, CFG_CHARGE_ATTACK_EFFECT_TICKS * entry.getLevel(), CFG_CHARGE_ATTACK_EFFECT_LEVEL - 1, false, false));
        user.m_7292_(new MobEffectInstance(MobEffects.f_19596_, CFG_CHARGE_ATTACK_EFFECT_TICKS * entry.getLevel(), CFG_CHARGE_ATTACK_EFFECT_LEVEL - 1, false, false));
        user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11928_, SoundSource.PLAYERS, 1.0f, 1.5f);
    }

    public static void gainStatic(IToolStackView tool, LivingEntity holder) {
        int charge = tool.getPersistentData().getInt(KEY_STATIC_ELECTRICITY);
        if (charge < CFG_CHARGE_REQUIRED) {
            if (++charge == CFG_CHARGE_REQUIRED) {
                holder.m_9236_().m_6263_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), SoundEvents.f_12291_, SoundSource.PLAYERS, 1.0f, 1.25f);
            }
            tool.getPersistentData().putInt(KEY_STATIC_ELECTRICITY, charge);
        }
    }

    @Override
    public void modifierOnInventoryTick(IToolStackView tool, ModifierEntry modifier, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.m_20184_().m_82553_() > 0.1 && world.m_46467_() % 40L == 0L) {
            StaticDischarge.gainStatic(tool, holder);
        }
    }

    @Override
    public void modifierProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (!StaticDischarge.isStaticReady(tool)) {
            StaticDischarge.gainStatic(tool, shooter);
        } else if (primary) {
            persistentData.putInt(KEY_STATIC_ELECTRICITY, 1);
            StaticDischarge.releaseStatic(tool, modifier, shooter);
        }
    }

    @Override
    public float onGetMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        if (StaticDischarge.isStaticReady(tool)) {
            StaticDischarge.releaseStatic(tool, modifier, context.getAttacker());
            damage *= CFG_CHARGE_ATTACK_MUL;
        } else {
            StaticDischarge.gainStatic(tool, context.getAttacker());
        }
        return damage;
    }

    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (context.getWorld().f_46443_) {
            return;
        }
        if (StaticDischarge.isStaticReady(tool)) {
            StaticDischarge.releaseStatic(tool, modifier, context.getLiving());
        } else {
            StaticDischarge.gainStatic(tool, context.getLiving());
        }
    }

    public List<Component> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(Component.m_237115_((String)(this.getTranslationKey() + ".flavor")).m_130940_(ChatFormatting.ITALIC), Component.m_237110_((String)(this.getTranslationKey() + ".description"), (Object[])new Object[]{CFG_CHARGE_REQUIRED, Float.valueOf(CFG_CHARGE_ATTACK_MUL), CFG_CHARGE_ATTACK_EFFECT_TICKS, CFG_CHARGE_ATTACK_EFFECT_LEVEL}).m_130940_(ChatFormatting.GRAY));
        }
        return this.descriptionList;
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return super.getDisplayName(tool, entry, access).m_6881_().m_130946_(" [" + tool.getPersistentData().getInt(KEY_STATIC_ELECTRICITY) + "]");
    }
}

