/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etstlib.entity.specialDamageSources;

import com.c2h6s.etstlib.entity.specialDamageSources.interfaces.IPercentageBypassArmor;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LegacyDamageSource
extends DamageSource
implements IPercentageBypassArmor {
    public String msgId = null;
    private float percentage = 0.0f;
    public ArrayList<ResourceKey<DamageType>> damageTypes = new ArrayList();

    public LegacyDamageSource(Holder<DamageType> holder, @Nullable Entity directEntity, @Nullable Entity causingEntity, @Nullable Vec3 sourcePos) {
        super(holder, directEntity, causingEntity, sourcePos);
    }

    public LegacyDamageSource(Holder<DamageType> holder, @Nullable Entity directEntity, @Nullable Entity causingEntity) {
        this(holder, directEntity, causingEntity, null);
    }

    public LegacyDamageSource(Holder<DamageType> holder, @Nullable Entity directEntity) {
        this(holder, directEntity, directEntity, null);
    }

    public LegacyDamageSource(@NotNull LivingEntity directEntity) {
        this((Holder<DamageType>)directEntity.m_269291_().m_269264_().m_269150_(), (Entity)directEntity, (Entity)directEntity, null);
    }

    public LegacyDamageSource(DamageSource source) {
        this((Holder<DamageType>)source.m_269150_(), source.m_7640_(), source.m_7639_(), source.m_269181_());
    }

    public static LegacyDamageSource playerAttack(@NotNull Player player) {
        return new LegacyDamageSource(player.m_269291_().m_269075_(player));
    }

    public static LegacyDamageSource mobAttack(@NotNull LivingEntity living) {
        return new LegacyDamageSource(living.m_269291_().m_269333_(living));
    }

    public static LegacyDamageSource indirectMagic(@NotNull LivingEntity living) {
        return new LegacyDamageSource((Holder<DamageType>)living.m_269291_().m_269425_().m_269150_(), (Entity)living);
    }

    public static LegacyDamageSource directMagic(@NotNull Level level) {
        return new LegacyDamageSource(level.m_269111_().m_269425_());
    }

    public static LegacyDamageSource any(@NotNull DamageSource source) {
        return new LegacyDamageSource(source);
    }

    public static LegacyDamageSource any(Holder<DamageType> holder, @Nullable Entity directEntity) {
        return new LegacyDamageSource(holder, directEntity);
    }

    public static LegacyDamageSource explosion(@NotNull Entity directEntity, Entity causingEntity) {
        return new LegacyDamageSource(directEntity.m_269291_().m_269036_(directEntity, causingEntity));
    }

    public static LegacyDamageSource explosion(@NotNull Explosion explosion) {
        return new LegacyDamageSource(explosion.m_46077_());
    }

    public static LegacyDamageSource thorns(@NotNull LivingEntity living) {
        return new LegacyDamageSource((Holder<DamageType>)living.m_269291_().m_269374_((Entity)living).m_269150_(), (Entity)living);
    }

    public LegacyDamageSource setBypassInvulnerableTime() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_273918_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setThorn() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268640_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setMagic() {
        this.damageTypes.add((ResourceKey<DamageType>)DamageTypes.f_268515_);
        return this;
    }

    public LegacyDamageSource setBypassArmor() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268490_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setBypassInvul() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268738_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setBypassMagic() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268630_.f_203868_()));
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268437_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setBypassEnchantment() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268413_.f_203868_()));
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268640_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setBypassShield() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_276146_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setExplosion() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268415_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setFire() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268745_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setProjectile() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268524_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setFreezing() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268419_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setFall() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268549_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setDrowning() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268581_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setDamageHelmet() {
        this.damageTypes.add((ResourceKey<DamageType>)ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)DamageTypeTags.f_268627_.f_203868_()));
        return this;
    }

    public LegacyDamageSource setPercentageBypassArmor(float percentage) {
        this.percentage = percentage;
        return this;
    }

    public LegacyDamageSource addPercentageBypassArmor(float percentage) {
        this.percentage += percentage;
        return this;
    }

    public LegacyDamageSource copyPropertiesFrom(LegacyDamageSource source) {
        this.damageTypes = source.damageTypes;
        this.msgId = source.msgId;
        this.percentage = source.percentage;
        return this;
    }

    public LegacyDamageSource setMsgId(String s) {
        this.msgId = s;
        return this;
    }

    public Component m_6157_(LivingEntity pLivingEntity) {
        ItemStack var10000;
        String $$1 = "death.attack." + (this.msgId == null ? this.m_269415_().f_268677_() : this.msgId);
        if (this.m_7639_() == null && this.m_7640_() == null) {
            LivingEntity $$5 = pLivingEntity.m_21232_();
            String $$6 = $$1 + ".player";
            return $$5 != null ? Component.m_237110_((String)$$6, (Object[])new Object[]{pLivingEntity.m_5446_(), $$5.m_5446_()}) : Component.m_237110_((String)$$1, (Object[])new Object[]{pLivingEntity.m_5446_()});
        }
        Component $$2 = this.m_7639_() == null ? this.m_7640_().m_5446_() : this.m_7639_().m_5446_();
        Entity var6 = this.m_7639_();
        if (var6 instanceof LivingEntity) {
            LivingEntity $$3 = (LivingEntity)var6;
            var10000 = $$3.m_21205_();
        } else {
            var10000 = ItemStack.f_41583_;
        }
        ItemStack $$4 = var10000;
        return !$$4.m_41619_() && $$4.m_41788_() ? Component.m_237110_((String)($$1 + ".item"), (Object[])new Object[]{pLivingEntity.m_5446_(), $$2, $$4.m_41611_()}) : Component.m_237110_((String)$$1, (Object[])new Object[]{pLivingEntity.m_5446_(), $$2});
    }

    @NotNull
    public String m_19385_() {
        return this.msgId != null ? this.msgId : super.m_19385_();
    }

    public boolean m_269533_(TagKey<DamageType> key) {
        if (!this.damageTypes.isEmpty()) {
            return this.damageTypes.contains(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)key.f_203868_())) || super.m_269533_(key);
        }
        return super.m_269533_(key);
    }

    public boolean m_276093_(ResourceKey<DamageType> key) {
        if (!this.damageTypes.isEmpty()) {
            return this.damageTypes.contains(key) || super.m_276093_(key);
        }
        return super.m_276093_(key);
    }

    @Override
    public float getPercentage() {
        return this.percentage;
    }
}

