/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.mixin;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.farm_and_charm.core.entity.BowlAccessor;
import net.satisfy.farm_and_charm.core.entity.ai.CatEatFromBowlGoal;
import net.satisfy.farm_and_charm.core.entity.ai.MeowAtBowlGoal;
import net.satisfy.farm_and_charm.core.mixin.MobAccessor;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.platform.PlatformHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cat.class})
public class CatMixin
implements BowlAccessor.FedTracker {
    @Unique
    private boolean farmAndCharm$fedFromBowl = false;
    @Unique
    private int farmAndCharm$fedTimer = 0;

    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void farmAndCharm$addFeedingGoal(CallbackInfo ci) {
        Mob self = (Mob)this;
        ((MobAccessor)self).farmAndCharm$getGoalSelector().m_25352_(13, (Goal)new CatEatFromBowlGoal((Cat)this));
        ((MobAccessor)self).farmAndCharm$getGoalSelector().m_25352_(14, (Goal)new MeowAtBowlGoal((Cat)this));
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void farmAndCharm$tickFedStatus(CallbackInfo ci) {
        if (this.farmAndCharm$fedFromBowl) {
            ++this.farmAndCharm$fedTimer;
            if (this.farmAndCharm$fedTimer >= 12000) {
                this.farmAndCharm$fedFromBowl = false;
                this.farmAndCharm$fedTimer = 0;
            }
        }
    }

    @Inject(method={"isFood"}, at={@At(value="HEAD")}, cancellable=true)
    private void farmAndCharm$allowCatFood(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (PlatformHelper.enableCatTamingChance() && itemStack.m_150930_(((Item)ObjectRegistry.CAT_FOOD.get()).m_5456_())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void farmAndCharm$$markAsFed() {
        this.farmAndCharm$fedFromBowl = true;
        this.farmAndCharm$fedTimer = 0;
    }

    @Override
    public void farmAndCharm$$resetFed() {
        this.farmAndCharm$fedFromBowl = false;
        this.farmAndCharm$fedTimer = 0;
    }

    @Override
    public boolean farmAndCharm$$isFed() {
        return this.farmAndCharm$fedFromBowl;
    }
}

