/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.block.PetBowlBlock;
import net.satisfy.farm_and_charm.core.block.entity.TextEditableBlockEntity;
import net.satisfy.farm_and_charm.core.registry.EntityTypeRegistry;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class PetBowlBlockEntity
extends BlockEntity
implements WorldlyContainer,
TextEditableBlockEntity {
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private boolean updatingState = false;
    private boolean fedDog;
    private boolean fedCat;
    private Component text = Component.m_237113_((String)"");

    public PetBowlBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.PET_BOWL_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] m_7071_(Direction side) {
        return new int[]{0};
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return (stack.m_150930_((Item)ObjectRegistry.DOG_FOOD.get()) || stack.m_150930_((Item)ObjectRegistry.CAT_FOOD.get())) && this.m_8020_(slot).m_41613_() < 4;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return ((ItemStack)this.items.get(0)).m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        this.m_6596_();
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack stack = ContainerHelper.m_18966_(this.items, (int)slot);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        if (stack.m_41619_()) {
            this.items.set(slot, (Object)ItemStack.f_41583_);
        } else {
            ItemStack current = (ItemStack)this.items.get(slot);
            if (current.m_41619_()) {
                this.items.set(slot, (Object)stack.m_41777_());
            } else if (ItemStack.m_150942_((ItemStack)current, (ItemStack)stack)) {
                int newCount = Math.min(4, current.m_41613_() + stack.m_41613_());
                current.m_41764_(newCount);
                this.items.set(slot, (Object)current);
            }
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.fedDog = tag.m_128471_("FedDog");
        this.fedCat = tag.m_128471_("FedCat");
        if (tag.m_128441_("Text0")) {
            this.text = Component.Serializer.m_130701_((String)tag.m_128461_("Text0"));
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128379_("FedDog", this.fedDog);
        tag.m_128379_("FedCat", this.fedCat);
        tag.m_128359_("Text0", Component.Serializer.m_130703_((Component)this.text));
    }

    public void m_6596_() {
        super.m_6596_();
        if (!this.updatingState) {
            this.updatingState = true;
            this.updateBlockState();
            this.updatingState = false;
        }
    }

    private void updateBlockState() {
        BlockState state;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && (state = this.f_58857_.m_8055_(this.f_58858_)).m_60734_() instanceof PetBowlBlock) {
            GeneralUtil.FoodType newType = GeneralUtil.FoodType.NONE;
            ItemStack stack = (ItemStack)this.items.get(0);
            if (!stack.m_41619_()) {
                if (stack.m_150930_((Item)ObjectRegistry.CAT_FOOD.get())) {
                    newType = GeneralUtil.FoodType.CAT;
                } else if (stack.m_150930_((Item)ObjectRegistry.DOG_FOOD.get())) {
                    newType = GeneralUtil.FoodType.DOG;
                }
            }
            if (state.m_61143_(PetBowlBlock.FOOD_TYPE) != newType) {
                BlockState newState = (BlockState)state.m_61124_(PetBowlBlock.FOOD_TYPE, (Comparable)((Object)newType));
                this.f_58857_.m_7731_(this.f_58858_, newState, 3);
                this.f_58857_.m_7260_(this.f_58858_, state, newState, 3);
            }
        }
    }

    public void onFed(ItemStack stack) {
        if (stack.m_150930_((Item)ObjectRegistry.DOG_FOOD.get())) {
            this.fedDog = true;
        } else if (stack.m_150930_((Item)ObjectRegistry.CAT_FOOD.get())) {
            this.fedCat = true;
        }
    }

    public void decreaseFood() {
        ItemStack stack = (ItemStack)this.items.get(0);
        if (!stack.m_41619_()) {
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                this.items.set(0, (Object)ItemStack.f_41583_);
            }
            this.m_6596_();
        }
    }

    public boolean wasCatFed() {
        return this.fedCat;
    }

    public void resetFedFlags() {
        this.fedDog = false;
        this.fedCat = false;
        this.m_6596_();
    }

    public Component getText() {
        return this.text;
    }

    @Override
    public void setText(int line, Component text) {
        if (line == 0) {
            this.text = text;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Override
    public int getTextLineCount() {
        return 1;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public boolean canBeUsedBy(Animal animal) {
        if (this.text.getString().isBlank()) {
            return true;
        }
        return animal.m_8077_() && animal.m_7755_().getString().equals(this.text.getString());
    }
}

