/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import com.logisticscraft.occlusionculling.util.Vec3d;
import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.versionless.EntityCullingVersionlessBase;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CullTask
implements Runnable {
    public boolean requestCull = false;
    public boolean disableEntityCulling = false;
    public boolean disableBlockEntityCulling = false;
    private final OcclusionCullingInstance culling;
    private final Minecraft client = Minecraft.m_91087_();
    private final int sleepDelay;
    private final int hitboxLimit;
    private final Set<BlockEntityType<?>> blockEntityWhitelist;
    private final Set<EntityType<?>> entityWhistelist;
    public double lastTime;
    private Vec3d lastPos;
    private Vec3d aabbMin;
    private Vec3d aabbMax;
    private boolean ingame;
    private List<Entity> entitiesForRendering;
    private Map<BlockPos, BlockEntity> blockEntities;
    private Vec3 cameraMC;

    public CullTask(OcclusionCullingInstance culling, Set<BlockEntityType<?>> blockEntityWhitelist, Set<EntityType<?>> entityWhistelist) {
        this.sleepDelay = EntityCullingModBase.instance.config.sleepDelay;
        this.hitboxLimit = EntityCullingModBase.instance.config.hitboxLimit;
        this.lastTime = 0.0;
        this.lastPos = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMin = new Vec3d(0.0, 0.0, 0.0);
        this.aabbMax = new Vec3d(0.0, 0.0, 0.0);
        this.ingame = false;
        this.entitiesForRendering = new ArrayList<Entity>();
        this.blockEntities = new HashMap<BlockPos, BlockEntity>();
        this.cameraMC = new Vec3(0.0, 0.0, 0.0);
        this.culling = culling;
        this.blockEntityWhitelist = blockEntityWhitelist;
        this.entityWhistelist = entityWhistelist;
    }

    @Override
    public void run() {
        while (Minecraft.m_91087_().m_91396_()) {
            try {
                Thread.sleep(this.sleepDelay);
                if (EntityCullingVersionlessBase.enabled && this.ingame) {
                    if (!this.requestCull && this.cameraMC.f_82479_ == this.lastPos.x && this.cameraMC.f_82480_ == this.lastPos.y && this.cameraMC.f_82481_ == this.lastPos.z) continue;
                    long start = System.nanoTime();
                    this.requestCull = false;
                    this.lastPos.set(this.cameraMC.f_82479_, this.cameraMC.f_82480_, this.cameraMC.f_82481_);
                    Vec3d camera = this.lastPos;
                    this.culling.resetCache();
                    this.cullBlockEntities(this.cameraMC, camera);
                    this.cullEntities(this.cameraMC, camera);
                    this.lastTime = (double)(System.nanoTime() - start) / 1000000.0;
                    continue;
                }
                this.lastTime = 0.0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Shutting down culling task!");
    }

    private void cullEntities(Vec3 cameraMC, Vec3d camera) {
        if (this.disableEntityCulling) {
            return;
        }
        Entity entity2 = null;
        for (Entity entity2 : this.entitiesForRendering) {
            Cullable cullable;
            if (entity2 == null) break;
            if (!(entity2 instanceof Cullable) || this.entityWhistelist.contains(entity2.m_6095_()) || EntityCullingModBase.instance.isDynamicWhitelisted(entity2) || (cullable = (Cullable)entity2).isForcedVisible()) continue;
            if (Minecraft.m_91087_().m_91314_(entity2)) {
                cullable.setCulled(false);
                continue;
            }
            if (!entity2.m_20182_().m_82509_((Position)cameraMC, (double)EntityCullingModBase.instance.config.tracingDistance)) {
                cullable.setCulled(false);
                continue;
            }
            AABB boundingBox = NMSCullingHelper.getCullingBox(entity2);
            if (boundingBox == null || boundingBox.m_82362_() > (double)this.hitboxLimit || boundingBox.m_82376_() > (double)this.hitboxLimit || boundingBox.m_82385_() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
            this.aabbMax.set(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private void cullBlockEntities(Vec3 cameraMC, Vec3d camera) {
        if (this.disableBlockEntityCulling) {
            return;
        }
        Iterator<Map.Entry<BlockPos, BlockEntity>> iterator = this.blockEntities.entrySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos;
            Cullable cullable;
            Map.Entry<BlockPos, BlockEntity> entry;
            try {
                entry = iterator.next();
            }
            catch (NullPointerException | ConcurrentModificationException ex) {
                break;
            }
            if (entry == null) break;
            if (this.blockEntityWhitelist.contains(entry.getValue().m_58903_()) || this.client.m_167982_().m_112265_(entry.getValue()) == null || EntityCullingModBase.instance.isDynamicWhitelisted(entry.getValue()) || (cullable = (Cullable)entry.getValue()).isForcedVisible() || !CullTask.closerThan(pos = entry.getKey(), (Position)cameraMC, 64.0)) continue;
            AABB boundingBox = EntityCullingModBase.instance.setupAABB(entry.getValue(), pos);
            if (boundingBox.m_82362_() > (double)this.hitboxLimit || boundingBox.m_82376_() > (double)this.hitboxLimit || boundingBox.m_82385_() > (double)this.hitboxLimit) {
                cullable.setCulled(false);
                continue;
            }
            this.aabbMin.set(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
            this.aabbMax.set(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
            boolean visible = this.culling.isAABBVisible(this.aabbMin, this.aabbMax, camera);
            cullable.setCulled(!visible);
        }
    }

    private static boolean closerThan(BlockPos blockPos, Position position, double d) {
        return CullTask.distSqr(blockPos, position.m_7096_(), position.m_7098_(), position.m_7094_(), true) < d * d;
    }

    private static double distSqr(BlockPos blockPos, double d, double e, double f, boolean bl) {
        double g = bl ? 0.5 : 0.0;
        double h = (double)blockPos.m_123341_() + g - d;
        double i = (double)blockPos.m_123342_() + g - e;
        double j = (double)blockPos.m_123343_() + g - f;
        return h * h + i * i + j * j;
    }

    @Generated
    public void setIngame(boolean ingame) {
        this.ingame = ingame;
    }

    @Generated
    public void setEntitiesForRendering(List<Entity> entitiesForRendering) {
        this.entitiesForRendering = entitiesForRendering;
    }

    @Generated
    public void setBlockEntities(Map<BlockPos, BlockEntity> blockEntities) {
        this.blockEntities = blockEntities;
    }

    @Generated
    public void setCameraMC(Vec3 cameraMC) {
        this.cameraMC = cameraMC;
    }
}

