/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ConductingModifier
extends Modifier
implements ConditionalStatModifierHook,
TooltipModifierHook,
MeleeDamageModifierHook {
    private static final Component BOOST = TConstruct.makeTranslation("modifier", "conducting.boost");
    private static final int MAX_BONUS_TICKS = 200;
    private static final float PERCENT_PER_LEVEL = 0.2f;

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.MONSTER_MELEE_DAMAGE);
    }

    @Override
    public int getPriority() {
        return 90;
    }

    public static float bonusScale(LivingEntity living) {
        int fire = living.m_20094_();
        if (fire > 0) {
            float bonus = 1.0f;
            if (fire < 200) {
                bonus *= (float)fire / 200.0f;
            }
            if (living.m_21023_(MobEffects.f_19607_)) {
                bonus /= 2.0f;
            }
            return bonus;
        }
        return 0.0f;
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        float bonus = ConductingModifier.bonusScale(context.getAttacker()) * modifier.getEffectiveLevel() * 0.2f;
        if (bonus > 0.0f) {
            damage *= 1.0f + bonus;
        }
        return damage;
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.PROJECTILE_DAMAGE && (bonus = ConductingModifier.bonusScale(living) * modifier.getEffectiveLevel() * 0.2f) > 0.0f) {
            baseValue *= 1.0f + bonus;
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        if (tool.hasTag(TinkerTags.Items.RANGED) || tool.hasTag(TinkerTags.Items.MELEE)) {
            float bonus = 0.2f * (float)modifier.getLevel();
            if (player != null && key == TooltipKey.SHIFT && player.m_20094_() == 0) {
                bonus = 0.0f;
            }
            tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_BOOST_FORMAT.format(bonus) + " ")).m_7220_(BOOST)));
        }
    }
}

