/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import javax.annotation.Nullable;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.TagUtil;

public class FloatToolStat
implements INumericToolStat<Float> {
    private final ToolStatId name;
    private final TextColor color;
    private final float defaultValue;
    private final float minValue;
    private final float maxValue;
    private final IJsonPredicate<Item> items;

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue, IJsonPredicate<Item> items) {
        this.name = name;
        this.color = TextColor.m_131266_((int)color);
        this.defaultValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.items = items;
    }

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue, @Nullable TagKey<Item> tag) {
        this(name, color, defaultValue, minValue, maxValue, (IJsonPredicate<Item>)(tag == null ? ItemPredicate.ANY : ItemPredicate.tag(tag)));
    }

    public FloatToolStat(ToolStatId name, int color, float defaultValue, float minValue, float maxValue) {
        this(name, color, defaultValue, minValue, maxValue, (IJsonPredicate<Item>)ItemPredicate.ANY);
    }

    @Override
    public boolean supports(Item item) {
        return this.items.matches((Object)item);
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(this.defaultValue);
    }

    @Override
    public Float clamp(Float value) {
        return Float.valueOf(Mth.m_14036_((float)value.floatValue(), (float)this.getMinValue(), (float)this.getMaxValue()));
    }

    @Override
    public FloatBuilder makeBuilder() {
        return new FloatBuilder(this.defaultValue);
    }

    @Override
    public void update(ModifierStatsBuilder builder, Float value) {
        builder.updateStat(this, b -> {
            b.add += value.floatValue();
            b.base = 0.0f;
        });
    }

    @Override
    public void add(ModifierStatsBuilder builder, double value) {
        builder.updateStat(this, b -> {
            b.add = (float)((double)b.add + value);
        });
    }

    @Override
    public void percent(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            b.percent = (float)((double)b.percent + factor);
        });
    }

    @Override
    public void multiply(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            b.multiply = (float)((double)b.multiply * factor);
        });
    }

    @Override
    public void multiplyAll(ModifierStatsBuilder builder, double factor) {
        builder.updateStat(this, b -> {
            b.multiply = (float)((double)b.multiply * factor);
        });
        builder.multiplier(this, factor);
    }

    @Override
    public Float build(ModifierStatsBuilder parent, Object builderObj) {
        FloatBuilder builder = (FloatBuilder)builderObj;
        return Float.valueOf((builder.base + builder.add) * (1.0f + builder.percent) * builder.multiply);
    }

    @Override
    @Nullable
    public Float read(Tag tag) {
        if (TagUtil.isNumeric(tag)) {
            return Float.valueOf(((NumericTag)tag).m_7057_());
        }
        return null;
    }

    @Override
    public Tag write(Float value) {
        return FloatTag.m_128566_((float)value.floatValue());
    }

    @Override
    public Float deserialize(JsonElement json) {
        return Float.valueOf(GsonHelper.m_13888_((JsonElement)json, (String)this.getName().toString()));
    }

    @Override
    public JsonElement serialize(Float value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Float fromNetwork(FriendlyByteBuf buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, Float value) {
        buffer.writeFloat(value.floatValue());
    }

    @Override
    public Component formatValue(float value) {
        return IToolStat.formatNumber(this.getTranslationKey(), this.getColor(), value);
    }

    public String toString() {
        return "FloatToolStat{" + this.name + "}";
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    public TextColor getColor() {
        return this.color;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    protected static class FloatBuilder {
        private float base;
        private float add = 0.0f;
        private float percent = 0.0f;
        private float multiply = 1.0f;

        public FloatBuilder(float base) {
            this.base = base;
        }
    }
}

