/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.book.content;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.ForgeI18n;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.BookScreen;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.mantle.util.ItemStackList;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.book.elements.CycleRecipeElement;
import slimeknights.tconstruct.library.client.book.elements.TinkerItemElement;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;

public class ContentModifier
extends PageContent {
    public static final transient ResourceLocation ID = TConstruct.getResource("modifier");
    public static final transient int TEX_SIZE = 256;
    public static final ResourceLocation BOOK_MODIFY = TConstruct.getResource("textures/gui/book/modify.png");
    private static final transient String KEY_EFFECTS = TConstruct.makeTranslationKey("book", "modifiers.effect");
    public static final transient ImageData IMG_SLOT_1 = new ImageData(BOOK_MODIFY, 0, 75, 22, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_2 = new ImageData(BOOK_MODIFY, 0, 97, 40, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_3 = new ImageData(BOOK_MODIFY, 0, 119, 58, 22, 256, 256);
    public static final transient ImageData IMG_SLOT_4 = new ImageData(BOOK_MODIFY, 0, 141, 40, 40, 256, 256);
    public static final transient ImageData IMG_SLOT_5 = new ImageData(BOOK_MODIFY, 0, 181, 58, 41, 256, 256);
    public static final transient ImageData IMG_TABLE = new ImageData(BOOK_MODIFY, 214, 0, 42, 46, 256, 256);
    public static final transient ImageData[] IMG_SLOTS = new ImageData[]{IMG_SLOT_1, IMG_SLOT_2, IMG_SLOT_3, IMG_SLOT_4, IMG_SLOT_5};
    public static final transient int[] SLOTS_X = new int[]{3, 21, 39, 12, 30};
    public static final transient int[] SLOTS_Y = new int[]{3, 3, 3, 22, 22};
    public static final transient int[] SLOTS_X_4 = new int[]{3, 21, 3, 21};
    public static final transient int[] SLOTS_Y_4 = new int[]{3, 3, 22, 22};
    @Nullable
    private transient Modifier modifier;
    private transient List<IDisplayModifierRecipe> recipes;
    @Nullable
    private transient TagKey<Item> toolFilterTag;
    private transient int currentRecipe = 0;
    private final transient List<BookElement> parts = new ArrayList<BookElement>();
    public TextData[] text;
    public String[] effects;
    public boolean more_text_space = false;
    @SerializedName(value="modifier_id")
    public String modifierID;
    @SerializedName(value="tool_filter")
    public String toolFilter = null;

    public ContentModifier() {
    }

    public ContentModifier(Modifier modifier) {
        this.modifier = modifier;
        this.modifierID = modifier.getId().toString();
        this.text = new TextData[]{new TextData(ForgeI18n.getPattern((String)(modifier.getTranslationKey() + ".description")))};
        this.effects = new String[0];
        this.more_text_space = true;
    }

    public Modifier getModifier() {
        if (this.modifier == null) {
            if (this.modifierID == null) {
                this.modifierID = this.parent.name;
            }
            this.modifier = ModifierManager.getValue(new ModifierId(this.modifierID));
        }
        return this.modifier;
    }

    @Nullable
    public TagKey<Item> getToolFilterTag() {
        if (this.toolFilter == null) {
            return null;
        }
        if (this.toolFilterTag == null) {
            this.toolFilterTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(this.toolFilter));
        }
        return this.toolFilterTag;
    }

    @Nonnull
    public String getTitle() {
        return this.getModifier().getDisplayName().getString();
    }

    public void load() {
        if (this.recipes == null) {
            Modifier modifier = this.getModifier();
            if (modifier == ModifierManager.INSTANCE.getDefaultValue()) {
                this.recipes = Collections.emptyList();
            } else {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                assert (level != null);
                this.recipes = RecipeHelper.getJEIRecipes((RegistryAccess)level.m_9598_(), (RecipeManager)level.m_7465_(), (RecipeType)((RecipeType)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().filter(recipe -> recipe.getDisplayResult().matches(modifier)).collect(Collectors.toList());
            }
        }
    }

    public void build(BookData book, ArrayList<BookElement> list, boolean brightSide) {
        int size;
        Modifier modifier = this.getModifier();
        if (modifier == ModifierManager.INSTANCE.getDefaultValue()) {
            list.add((BookElement)new ImageElement(0, 0, 32, 32, ImageData.MISSING));
            System.out.println("Modifier with id " + this.modifierID + " not found");
            return;
        }
        this.addTitle(list, this.getTitle(), true, modifier.getColor());
        int y = this.getTitleHeight();
        int h = this.more_text_space ? 83 : 50;
        list.add((BookElement)new TextElement(5, y, 172, h, this.text));
        if (this.effects.length > 0) {
            TextData head = new TextData(I18n.m_118938_((String)KEY_EFFECTS, (Object[])new Object[0]));
            head.underlined = true;
            list.add((BookElement)new TextElement(5, y + h, 86, 176 - h - 20, new TextData[]{head}));
            ArrayList effectData = Lists.newArrayList();
            for (String e : this.effects) {
                effectData.add(new TextData("\u25cf "));
                effectData.add(new TextData(e));
                effectData.add(new TextData("\n"));
            }
            list.add((BookElement)new TextElement(5, y + 14 + h, 98, 176 - h - 20, (Collection)effectData));
        }
        if ((size = this.recipes.size()) > 0) {
            if (size > 1) {
                int col = book.appearance.structureButtonColor;
                int colHover = book.appearance.structureButtonColorHovered;
                list.add((BookElement)new CycleRecipeElement(182 - ArrowButton.ArrowType.RIGHT.w - 32, 160, ArrowButton.ArrowType.RIGHT, col, colHover, this, book, list));
            }
            this.buildAndAddRecipeDisplay(book, list, this.recipes.get(this.currentRecipe), null);
        }
    }

    public void buildAndAddRecipeDisplay(BookData book, ArrayList<BookElement> list, @Nullable IDisplayModifierRecipe recipe, @Nullable BookScreen parent) {
        if (recipe != null) {
            int inputs = recipe.getInputCount();
            ImageData img = IMG_SLOTS[Math.min(inputs - 1, 4)];
            if (inputs > 5) {
                TConstruct.LOG.warn("Too many inputs in recipe {}, size {}", (Object)recipe, (Object)inputs);
            }
            int[] slotsX = SLOTS_X;
            int[] slotsY = SLOTS_Y;
            if (inputs == 4) {
                slotsX = SLOTS_X_4;
                slotsY = SLOTS_Y_4;
            }
            int imgX = 111;
            int imgY = 118;
            imgX = imgX + 29 - img.width / 2;
            imgY = imgY + 20 - img.height / 2;
            ImageElement table = new ImageElement(imgX + (img.width - ContentModifier.IMG_TABLE.width) / 2, imgY - 24, -1, -1, IMG_TABLE);
            table.parent = parent;
            this.parts.add((BookElement)table);
            list.add((BookElement)table);
            ImageElement slot = new ImageElement(imgX, imgY, -1, -1, img, book.appearance.slotColor);
            slot.parent = parent;
            this.parts.add((BookElement)slot);
            list.add((BookElement)slot);
            List<ItemStack> demo = recipe.getToolWithModifier();
            TagKey<Item> filterTag = this.getToolFilterTag();
            if (filterTag != null) {
                demo = demo.stream().filter(stack -> stack.m_204117_(filterTag)).toList();
            }
            if (!demo.isEmpty()) {
                TinkerItemElement demoTools = new TinkerItemElement(imgX + (img.width - 16) / 2, imgY - 24, 1.0f, (Collection<ItemStack>)this.getDemoTools(demo));
                demoTools.parent = parent;
                this.parts.add((BookElement)demoTools);
                list.add((BookElement)demoTools);
            }
            ImageElement image = new ImageElement(imgX + (img.width - 22) / 2, imgY - 27, -1, -1, IMG_SLOT_1, 0xFFFFFF);
            image.parent = parent;
            this.parts.add((BookElement)image);
            list.add((BookElement)image);
            for (int i = 0; i < Math.min(inputs, 5); ++i) {
                TinkerItemElement part = new TinkerItemElement(imgX + slotsX[i], imgY + slotsY[i], 1.0f, recipe.getDisplayItems(i));
                if (parent != null) {
                    part.parent = parent;
                }
                this.parts.add((BookElement)part);
                list.add((BookElement)part);
            }
        }
    }

    protected ItemStackList getDemoTools(List<ItemStack> stacks) {
        ItemStackList demo = ItemStackList.withSize((int)stacks.size());
        for (int i = 0; i < stacks.size(); ++i) {
            demo.set(i, (Object)stacks.get(i));
        }
        return demo;
    }

    public void nextRecipe(BookData book, ArrayList<BookElement> list) {
        if (!this.recipes.isEmpty()) {
            ++this.currentRecipe;
            if (this.currentRecipe >= this.recipes.size()) {
                this.currentRecipe = 0;
            }
            BookScreen parent = this.parts.get((int)0).parent;
            for (BookElement element : this.parts) {
                list.remove(element);
            }
            this.parts.clear();
            this.buildAndAddRecipeDisplay(book, list, this.recipes.get(this.currentRecipe), parent);
        }
    }
}

