/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.model.BakedModelHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.StitchedSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.Nullable;

public class ExtendedWrenchItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final RendererReloadCache<ResourceLocation, TextureAtlasSprite> CACHED_TEXTURES = new RendererReloadCache(ExtendedWrenchItemRenderer::getAtlasSprite);
    private static final RendererReloadCache<ResourceLocation, ResourceLocation> CACHED_MATERIAL_TEXTURE_LOCATIONS = new RendererReloadCache(ExtendedWrenchItemRenderer::getAbsentMaterialTexture);
    public static final StitchedSprite HEAD_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/head_materials/gold"));
    public static final StitchedSprite HANDLE_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/handle_materials/dark_oak"));
    public static final StitchedSprite AXIS_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/axis_materials/andesite"));
    public static final StitchedSprite COG_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/cog_materials/spruce"));
    protected static final PartialModel GEAR = PartialModel.of((ResourceLocation)ExtendedWrenches.asResource("item/extended_wrench/gear"));

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ResourceLocation headMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.HEAD);
        ResourceLocation handleMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.HANDLE);
        ResourceLocation cogMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.COG);
        ResourceLocation axisMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.AXIS);
        BakedModel replacedBody = ExtendedWrenchItemRenderer.generateBodyModel(model.getOriginalModel(), headMaterial, handleMaterial, axisMaterial);
        renderer.render(replacedBody, light);
        float xOffset = -0.0625f;
        ms.m_252880_(-xOffset, 0.0f, 0.0f);
        ms.m_252781_(Axis.f_252436_.m_252977_(ScrollValueHandler.getScroll((float)AnimationTickHolder.getPartialTicks())));
        ms.m_252880_(xOffset, 0.0f, 0.0f);
        BakedModel replacedCog = ExtendedWrenchItemRenderer.generateCogModel(GEAR.get(), cogMaterial);
        renderer.render(replacedCog, light);
    }

    public static BakedModel generateBodyModel(BakedModel template, @Nullable ResourceLocation headTexture, @Nullable ResourceLocation handleTexture, @Nullable ResourceLocation axisTexture) {
        TextureAtlasSprite headReplacement = HEAD_TEXTURE.get();
        if (headTexture != null) {
            headReplacement = (TextureAtlasSprite)CACHED_TEXTURES.get((Object)headTexture);
        }
        TextureAtlasSprite handleReplacement = HANDLE_TEXTURE.get();
        if (handleTexture != null) {
            handleReplacement = (TextureAtlasSprite)CACHED_TEXTURES.get((Object)handleTexture);
        }
        TextureAtlasSprite axisReplacement = AXIS_TEXTURE.get();
        if (axisTexture != null) {
            axisReplacement = (TextureAtlasSprite)CACHED_TEXTURES.get((Object)axisTexture);
        }
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(HEAD_TEXTURE.get(), headReplacement);
        map.put(HANDLE_TEXTURE.get(), handleReplacement);
        map.put(AXIS_TEXTURE.get(), axisReplacement);
        return BakedModelHelper.generateModel((BakedModel)template, ((Map)map)::get);
    }

    public static BakedModel generateCogModel(BakedModel template, @Nullable ResourceLocation cogTexture) {
        TextureAtlasSprite cogReplacement = COG_TEXTURE.get();
        if (cogTexture != null) {
            cogReplacement = (TextureAtlasSprite)CACHED_TEXTURES.get((Object)cogTexture);
        }
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(COG_TEXTURE.get(), cogReplacement);
        return BakedModelHelper.generateModel((BakedModel)template, ((Map)map)::get);
    }

    private static TextureAtlasSprite getAtlasSprite(ResourceLocation location) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(location);
    }

    private static ResourceLocation getMaterialTexture(ItemStack stack, WrenchPart part) {
        CompoundTag display = stack.m_41698_("display");
        CompoundTag materialTag = display.m_128469_("materials");
        String materialLocationStr = materialTag.m_128469_(part.m_7912_()).m_128461_("location");
        if (materialLocationStr.isEmpty()) {
            return null;
        }
        ResourceLocation materialLocation = new ResourceLocation(materialLocationStr);
        return (ResourceLocation)CACHED_MATERIAL_TEXTURE_LOCATIONS.get((Object)materialLocation);
    }

    @Nullable
    private static ResourceLocation getAbsentMaterialTexture(ResourceLocation location) {
        RegistryAccess access = ExtendedWrenchItemRenderer.getRegistryAccess();
        if (access == null) {
            return null;
        }
        Registry materials = access.m_175515_(ExtendedWrenchesData.WRENCH_MATERIAL);
        Optional optMaterial = materials.m_6612_(location);
        return optMaterial.isPresent() ? ((WrenchMaterial)optMaterial.get()).texture() : null;
    }

    @Nullable
    private static RegistryAccess getRegistryAccess() {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return null;
        }
        return level.m_9598_();
    }
}

