/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.compat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;

public class WoodGood
extends SimpleModule {
    public WoodGood(String modId) {
        super(modId, "cew", "everycomp");
    }

    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood((WoodType)woodType)) continue;
                try {
                    TextureImage cogTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extendedwrenches", (String)"item/extended_wrench/cog_materials/oak"));
                    try {
                        TextureImage handleTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"extendedwrenches", (String)"item/extended_wrench/handle_materials/oak"));
                        try {
                            TextureImage plankTexture = TextureImage.open((ResourceManager)manager, (ResourceLocation)RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)woodType.planks));
                            try {
                                Respriter cogRespriter = Respriter.of((TextureImage)cogTexture);
                                Respriter handleRespriter = Respriter.of((TextureImage)handleTexture);
                                List plankPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                                McMetaFile plankMeta = plankTexture.getMcMeta();
                                try {
                                    TextureImage cogRecolored = cogRespriter.recolorWithAnimation(plankPalette, plankMeta);
                                    try {
                                        TextureImage handleRecolored = handleRespriter.recolorWithAnimation(plankPalette, plankMeta);
                                        try {
                                            sink.addTexture(this.getCogTexturePath(woodType), cogRecolored);
                                            sink.addTexture(this.getHandleTexturePath(woodType), handleRecolored);
                                        }
                                        finally {
                                            if (handleRecolored == null) continue;
                                            handleRecolored.close();
                                        }
                                    }
                                    finally {
                                        if (cogRecolored == null) continue;
                                        cogRecolored.close();
                                    }
                                }
                                catch (Exception e) {
                                    ExtendedWrenches.LOGGER.error("Error generating texture", (Throwable)e);
                                }
                            }
                            finally {
                                if (plankTexture == null) continue;
                                plankTexture.close();
                            }
                        }
                        finally {
                            if (handleTexture == null) continue;
                            handleTexture.close();
                        }
                    }
                    finally {
                        if (cogTexture == null) continue;
                        cogTexture.close();
                    }
                }
                catch (Exception e) {
                    ExtendedWrenches.LOGGER.error("Error generating texture", (Throwable)e);
                }
            }
        });
    }

    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood((WoodType)woodType)) continue;
                JsonObject cogMaterial = new JsonObject();
                cogMaterial.add("part", (JsonElement)new JsonPrimitive("cog"));
                cogMaterial.add("texture", (JsonElement)new JsonPrimitive(this.getCogTexturePath(woodType).toString()));
                sink.addJson(ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("extendedwrenches/wrench_material/" + woodType.getAppendableId() + "_cog")), (JsonElement)cogMaterial, ResType.JSON);
                JsonObject additionItem = new JsonObject();
                additionItem.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.f_257033_.m_7981_((Object)woodType.planks.m_5456_()).toString()));
                JsonObject cogRecipe = new JsonObject();
                cogRecipe.add("type", (JsonElement)new JsonPrimitive("extendedwrenches:wrench_material_swap"));
                cogRecipe.add("addition", (JsonElement)additionItem);
                cogRecipe.add("material", (JsonElement)new JsonPrimitive("everycomp:" + woodType.getAppendableId() + "_cog"));
                cogRecipe.add("part", (JsonElement)new JsonPrimitive("cog"));
                JsonObject cogTemplateItem = new JsonObject();
                cogTemplateItem.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)ExtendedItems.WRENCH_COG_AUGMENT.get())).toString()));
                cogRecipe.add("template", (JsonElement)cogTemplateItem);
                sink.addJson(ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("wrench/cog/" + woodType.getAppendableId() + "_cog_swap")), (JsonElement)cogRecipe, ResType.RECIPES);
                JsonObject handleMaterial = new JsonObject();
                handleMaterial.add("part", (JsonElement)new JsonPrimitive("handle"));
                handleMaterial.add("texture", (JsonElement)new JsonPrimitive(this.getHandleTexturePath(woodType).toString()));
                sink.addJson(ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("extendedwrenches/wrench_material/" + woodType.getAppendableId() + "_handle")), (JsonElement)handleMaterial, ResType.JSON);
                JsonObject handleRecipe = new JsonObject();
                handleRecipe.add("type", (JsonElement)new JsonPrimitive("extendedwrenches:wrench_material_swap"));
                handleRecipe.add("addition", (JsonElement)additionItem);
                handleRecipe.add("material", (JsonElement)new JsonPrimitive("everycomp:" + woodType.getAppendableId() + "_handle"));
                handleRecipe.add("part", (JsonElement)new JsonPrimitive("handle"));
                JsonObject handleTemplateItem = new JsonObject();
                handleTemplateItem.add("item", (JsonElement)new JsonPrimitive(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)ExtendedItems.WRENCH_HANDLE_AUGMENT.get())).toString()));
                handleRecipe.add("template", (JsonElement)handleTemplateItem);
                sink.addJson(ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("wrench/handle/" + woodType.getAppendableId() + "_handle_swap")), (JsonElement)handleRecipe, ResType.RECIPES);
            }
        });
    }

    private ResourceLocation getCogTexturePath(WoodType woodType) {
        return ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("item/extended_wrench/cog_materials/" + woodType.getAppendableId()));
    }

    private ResourceLocation getHandleTexturePath(WoodType woodType) {
        return ResourceLocation.fromNamespaceAndPath((String)"everycomp", (String)("item/extended_wrench/handle_materials/" + woodType.getAppendableId()));
    }
}

