/*
 * Decompiled with CFR 0.152.
 */
package dev.doaddon.cornexpansion.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.doaddon.cornexpansion.CornExpansion;
import dev.doaddon.cornexpansion.blocks.EffectFoodBlock;
import dev.doaddon.cornexpansion.blocks.TinBlock;
import dev.doaddon.cornexpansion.items.EffectItem;
import dev.doaddon.cornexpansion.items.PlaceableEffectBlockItem;
import dev.doaddon.cornexpansion.items.StickFoodItem;
import dev.doaddon.cornexpansion.registry.CornExpansionCreativeTabs;
import dev.doaddon.cornexpansion.utils.CornExpansionFoodProperties;
import dev.doaddon.cornexpansion.utils.FoodUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.HoneyBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.satisfy.farm_and_charm.core.registry.MobEffectRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;

public class CornExpansionObjects {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"cornexpansion", (ResourceKey)Registries.f_256913_);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"cornexpansion", (ResourceKey)Registries.f_256747_);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Item> CORN_DOUGH = CornExpansionObjects.registerItem("corn_dough", () -> new Item(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(1, 0.1f, MobEffects.f_19612_, 300, false, false))));
    public static final RegistrySupplier<Item> CORN_FLOUR = CornExpansionObjects.registerItem("corn_flour", () -> new Item(CornExpansionObjects.getDefaultItemProperties()));
    public static final RegistrySupplier<Item> DRIED_CORN = CornExpansionObjects.registerItem("dried_corn", () -> new Item(CornExpansionObjects.getDefaultItemProperties()));
    public static final RegistrySupplier<Item> CORNMEAL = CornExpansionObjects.registerItem("cornmeal", () -> new Item(CornExpansionObjects.getDefaultItemProperties()));
    public static final RegistrySupplier<Item> CORN_SYRUP = CornExpansionObjects.registerItem("corn_syrup", () -> new HoneyBottleItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(7, 0.3f, MobEffects.f_19597_, 1200, true, false)).m_41487_(16).m_41495_(Items.f_42590_)));
    public static final RegistrySupplier<Item> DRIED_KERNELS = CornExpansionObjects.registerItem("dried_kernels", () -> new Item(CornExpansionObjects.getDefaultItemProperties()));
    public static final RegistrySupplier<Item> POPCORN = CornExpansionObjects.registerItem("popcorn", () -> new Item(CornExpansionObjects.getFoodItemSettings(CornExpansionFoodProperties.POPCORN_FOOD_PROPERTIES)));
    public static final RegistrySupplier<Item> SWEET_POPCORN = CornExpansionObjects.registerItem("sweet_popcorn", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(CornExpansionFoodProperties.SWEET_POPCORN_FOOD_PROPERTIES)));
    public static final RegistrySupplier<Item> BUTTERY_POPCORN = CornExpansionObjects.registerItem("buttery_popcorn", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(CornExpansionFoodProperties.BUTTERY_POPCORN_FOOD_PROPERTIES)));
    public static final RegistrySupplier<Item> CHEESY_POPCORN = CornExpansionObjects.registerItem("cheesy_popcorn", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(CornExpansionFoodProperties.CHEESY_POPCORN_FOOD_PROPERTIES)));
    public static final RegistrySupplier<Item> CANDIED_POPCORN = CornExpansionObjects.registerItem("candied_popcorn", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(CornExpansionFoodProperties.CANDIED_POPCORN_FOOD_PROPERTIES)));
    public static final RegistrySupplier<Item> CORN_ON_THE_COB = CornExpansionObjects.registerItem("corn_on_the_cob", () -> new StickFoodItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(2, 0.2f)).m_41487_(16)));
    public static final RegistrySupplier<Item> GRILLED_CORN = CornExpansionObjects.registerItem("grilled_corn", () -> new StickFoodItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(4, 0.4f)).m_41487_(16)));
    public static final RegistrySupplier<Block> POPCORN_TIN_BLOCK = CornExpansionObjects.registerWithoutItem("popcorn_tin", () -> new TinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 8, CornExpansionFoodProperties.POPCORN_FOOD_PROPERTIES));
    public static final RegistrySupplier<Block> SWEET_POPCORN_TIN_BLOCK = CornExpansionObjects.registerWithoutItem("sweet_popcorn_tin", () -> new TinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 8, CornExpansionFoodProperties.SWEET_POPCORN_FOOD_PROPERTIES));
    public static final RegistrySupplier<Block> BUTTERY_POPCORN_TIN_BLOCK = CornExpansionObjects.registerWithoutItem("buttery_popcorn_tin", () -> new TinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 8, CornExpansionFoodProperties.BUTTERY_POPCORN_FOOD_PROPERTIES));
    public static final RegistrySupplier<Block> CHEESY_POPCORN_TIN_BLOCK = CornExpansionObjects.registerWithoutItem("cheesy_popcorn_tin", () -> new TinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 8, CornExpansionFoodProperties.CHEESY_POPCORN_FOOD_PROPERTIES));
    public static final RegistrySupplier<Block> CANDIED_POPCORN_TIN_BLOCK = CornExpansionObjects.registerWithoutItem("candied_popcorn_tin", () -> new TinBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_), 8, CornExpansionFoodProperties.CANDIED_POPCORN_FOOD_PROPERTIES));
    public static final RegistrySupplier<Item> POPCORN_TIN = CornExpansionObjects.registerItem("popcorn_tin", () -> new PlaceableEffectBlockItem((EffectFoodBlock)((Object)((Object)POPCORN_TIN_BLOCK.get())), CornExpansionObjects.getDefaultItemProperties().m_41487_(16)));
    public static final RegistrySupplier<Item> SWEET_POPCORN_TIN = CornExpansionObjects.registerItem("sweet_popcorn_tin", () -> new PlaceableEffectBlockItem((EffectFoodBlock)((Object)((Object)SWEET_POPCORN_TIN_BLOCK.get())), CornExpansionObjects.getDefaultItemProperties().m_41487_(16)));
    public static final RegistrySupplier<Item> BUTTERY_POPCORN_TIN = CornExpansionObjects.registerItem("buttery_popcorn_tin", () -> new PlaceableEffectBlockItem((EffectFoodBlock)((Object)((Object)BUTTERY_POPCORN_TIN_BLOCK.get())), CornExpansionObjects.getDefaultItemProperties().m_41487_(16)));
    public static final RegistrySupplier<Item> CHEESY_POPCORN_TIN = CornExpansionObjects.registerItem("cheesy_popcorn_tin", () -> new PlaceableEffectBlockItem((EffectFoodBlock)((Object)((Object)CHEESY_POPCORN_TIN_BLOCK.get())), CornExpansionObjects.getDefaultItemProperties().m_41487_(16)));
    public static final RegistrySupplier<Item> CANDIED_POPCORN_TIN = CornExpansionObjects.registerItem("candied_popcorn_tin", () -> new PlaceableEffectBlockItem((EffectFoodBlock)((Object)((Object)CANDIED_POPCORN_TIN_BLOCK.get())), CornExpansionObjects.getDefaultItemProperties().m_41487_(16)));
    public static final RegistrySupplier<Item> GRANDMAS_CORNBREAD = CornExpansionObjects.registerItem("grandmas_cornbread", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(6, 0.9f, (MobEffect)MobEffectRegistry.GRANDMAS_BLESSING.get(), 1200, false, false))));
    public static final RegistrySupplier<Item> CORN_SYRUP_COOKIE = CornExpansionObjects.registerItem("corn_syrup_cookie", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(3, 0.2f, MobEffects.f_19597_, 600, false, false))));
    public static final RegistrySupplier<Item> POLENTA = CornExpansionObjects.registerItem("polenta", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(3, 0.2f, false, false))));
    public static final RegistrySupplier<Item> SWEET_POLENTA = CornExpansionObjects.registerItem("sweet_polenta", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(3, 0.2f, MobEffects.f_19596_, 1200, false, false))));
    public static final RegistrySupplier<Item> BUTTERY_POLENTA = CornExpansionObjects.registerItem("buttery_polenta", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(3, 0.4f, (RegistrySupplier<MobEffect>)MobEffectRegistry.SATIATION, 1200, false, false))));
    public static final RegistrySupplier<Item> CHEESY_POLENTA = CornExpansionObjects.registerItem("cheesy_polenta", () -> new EffectItem(CornExpansionObjects.getFoodItemSettings(FoodUtils.createFood(4, 0.4f, (RegistrySupplier<MobEffect>)MobEffectRegistry.SUSTENANCE, 1200, false, false))));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getDefaultItemProperties(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties().arch$tab(CornExpansionCreativeTabs.CORNEXPANSION_TAB);
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getDefaultItemProperties() {
        return CornExpansionObjects.getDefaultItemProperties(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return GeneralUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, (ResourceLocation)CornExpansion.id(name), block);
    }

    public static Item.Properties getFoodItemSettings(FoodProperties foodProperties) {
        return CornExpansionObjects.getDefaultItemProperties().m_41489_(foodProperties);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return GeneralUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, (ResourceLocation)CornExpansion.id(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return GeneralUtil.registerItem(ITEMS, ITEM_REGISTRAR, (ResourceLocation)CornExpansion.id(path), itemSupplier);
    }
}

