/*
 * Decompiled with CFR 0.152.
 */
package dev.doaddon.cornexpansion.blocks;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.farm_and_charm.core.block.FoodBlock;
import org.jetbrains.annotations.NotNull;

public class EffectFoodBlock
extends FoodBlock {
    private final int maxBites;
    public final FoodProperties foodComponent;

    public EffectFoodBlock(BlockBehaviour.Properties settings, int maxBites, FoodProperties foodComponent) {
        super(settings, maxBites, foodComponent);
        this.maxBites = maxBites;
        this.foodComponent = foodComponent;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (world.f_46443_) {
            if (this.tryEat((LevelAccessor)world, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.tryEat((LevelAccessor)world, pos, state, player);
    }

    private InteractionResult tryEat(LevelAccessor world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false) && !this.foodComponent.m_38747_() || !(world instanceof Level)) {
            return InteractionResult.PASS;
        }
        Level level = (Level)world;
        player.m_36324_().m_38707_(this.foodComponent.m_38744_(), this.foodComponent.m_38745_());
        for (Pair effect : this.foodComponent.m_38749_()) {
            if (level.f_46443_ || effect.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)effect.getSecond()).floatValue())) continue;
            player.m_7292_(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
        }
        for (int count = 0; count < 10; ++count) {
            double d0 = level.f_46441_.m_188583_() * 0.02;
            double d1 = level.f_46441_.m_188583_() * 0.02;
            double d2 = level.f_46441_.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, d0, d1, d2);
        }
        world.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        world.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites < this.maxBites - 1) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            world.m_46961_(pos, true);
            world.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }
}

