/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.accessories;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class AccessoriesCompat
implements ICompat {
    @Override
    public void setup() {
        InventoryHelper.registerPlayerInventoryProvider(player -> AccessoriesCapability.getOptionally((LivingEntity)player).map(cap -> new AccessoriesHandler((Player)player, (AccessoriesCapability)cap)).orElse(EmptyHandler.INSTANCE));
        InventoryHelper.registerEquipmentInventoryProvider(player -> AccessoriesCapability.getOptionally((LivingEntity)player).map(cap -> new AccessoriesHandler((Player)player, (AccessoriesCapability)cap)).orElse(EmptyHandler.INSTANCE));
    }

    private static class AccessoriesHandler
    implements IItemHandlerModifiable {
        private final AccessoriesCapability cap;
        private final Player player;
        private Map<SlotType, Integer> identifierBaseIndexes = new LinkedHashMap<SlotType, Integer>();
        private final int totalSize;

        public AccessoriesHandler(Player player, AccessoriesCapability cap) {
            this.cap = cap;
            this.player = player;
            AtomicInteger totalSlots = new AtomicInteger(0);
            cap.getContainers().forEach((identifier, container) -> {
                this.identifierBaseIndexes.put(container.slotType(), totalSlots.get());
                totalSlots.addAndGet(container.getSize());
            });
            this.totalSize = totalSlots.get();
        }

        public int getSlots() {
            return this.totalSize;
        }

        public ItemStack getStackInSlot(int i) {
            if (this.totalSize <= i) {
                return ItemStack.f_41583_;
            }
            return this.getContainer(i).getAccessories().m_8020_(this.getLocalIndex(i));
        }

        private AccessoriesContainer getContainer(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return container;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        private int getLocalIndex(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return slot - baseIndex;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        private SlotType getSlotType(int slot) {
            for (Map.Entry<SlotType, Integer> entry : this.identifierBaseIndexes.entrySet()) {
                AccessoriesContainer container;
                SlotType slotType = entry.getKey();
                int baseIndex = entry.getValue();
                if (slot >= baseIndex + (container = this.cap.getContainer(slotType)).getSize()) continue;
                return slotType;
            }
            throw new IndexOutOfBoundsException("Slot " + slot + " is out of bounds for accessories inventory of size " + this.totalSize);
        }

        public int getSlotLimit(int i) {
            if (this.totalSize <= i) {
                return 0;
            }
            return this.getContainer(i).getAccessories().m_6893_();
        }

        public boolean isItemValid(int i, ItemStack itemStack) {
            if (this.totalSize <= i) {
                return false;
            }
            return this.getContainer(i).getAccessories().m_7013_(this.getLocalIndex(i), itemStack);
        }

        public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
            if (this.totalSize <= slot) {
                return itemStack;
            }
            int localIndex = this.getLocalIndex(slot);
            SlotReference slotReference = SlotReference.of((LivingEntity)this.player, (String)this.getSlotType(slot).name(), (int)localIndex);
            ItemStack currentStack = slotReference.getStack();
            if (currentStack != null && !currentStack.m_41619_() && !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)currentStack)) {
                return itemStack;
            }
            int currentCount = currentStack != null ? currentStack.m_41613_() : 0;
            int countToInsert = Math.min(itemStack.m_41613_(), this.getContainer(slot).getAccessories().m_6893_() - currentCount);
            if (countToInsert <= 0 || !this.getContainer(slot).getAccessories().m_7013_(localIndex, itemStack)) {
                return itemStack;
            }
            if (!simulate) {
                slotReference.setStack(itemStack.m_255036_(countToInsert + currentCount));
            }
            if (itemStack.m_41613_() == countToInsert) {
                return ItemStack.f_41583_;
            }
            return itemStack.m_255036_(itemStack.m_41613_() - countToInsert);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.totalSize <= slot) {
                return ItemStack.f_41583_;
            }
            int localIndex = this.getLocalIndex(slot);
            SlotReference slotReference = SlotReference.of((LivingEntity)this.player, (String)this.getSlotType(slot).name(), (int)localIndex);
            ItemStack currentStack = slotReference.getStack();
            if (currentStack == null || currentStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int countToExtract = Math.min(amount, currentStack.m_41613_());
            ItemStack extractedStack = currentStack.m_255036_(countToExtract);
            if (!simulate) {
                if (currentStack.m_41613_() == countToExtract) {
                    slotReference.setStack(ItemStack.f_41583_);
                } else {
                    slotReference.setStack(currentStack.m_255036_(currentStack.m_41613_() - countToExtract));
                }
            }
            return extractedStack;
        }

        public void setStackInSlot(int i, ItemStack itemStack) {
            if (this.totalSize <= i) {
                return;
            }
            SlotReference slotReference = SlotReference.of((LivingEntity)this.player, (String)this.getSlotType(i).name(), (int)this.getLocalIndex(i));
            slotReference.setStack(itemStack);
        }
    }
}

