/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.spells.slime.slimeball;

import com.snackpirate.constructscasting.CCDamageTypes;
import com.snackpirate.constructscasting.spells.CCEntities;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.jetbrains.annotations.NotNull;

public class SlimeballProjectile
extends AbstractMagicProjectile
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> BOUNCES = SynchedEntityData.m_135353_(SlimeballProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SlimeballProjectile(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SlimeballProjectile(Level levelIn, Entity shooter, int spellLevel) {
        this((EntityType<? extends Projectile>)((EntityType)CCEntities.SLIMEBALL_PROJECTILE.get()), levelIn);
        this.setBounces(spellLevel);
        this.m_5602_(shooter);
    }

    public void trailParticles() {
    }

    public void impactParticles(double v, double v1, double v2) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123753_, (double)v, (double)v1, (double)v2, (int)5, (double)0.1, (double)0.1, (double)0.1, (double)0.25, (boolean)true);
    }

    public float getSpeed() {
        return 1.75f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return this.getBounces() == 0 ? Optional.of(SoundEvents.f_12389_) : Optional.of(SoundEvents.f_12388_);
    }

    protected void doImpactSound(SoundEvent sound) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.NEUTRAL, 2.0f, 1.2f + Utils.random.m_188501_() * 0.2f);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity target = pResult.m_82443_();
        DamageSources.applyDamage((Entity)target, (float)this.getDamage(), (DamageSource)DamageSources.get((Level)this.m_9236_(), CCDamageTypes.SLIME_MAGIC));
        if (this.getBounces() > 0) {
            double x = this.m_20184_().m_82490_((double)0.8).f_82479_;
            double y = this.m_20184_().m_82490_((double)0.8).f_82480_;
            double z = this.m_20184_().m_82490_((double)0.8).f_82481_;
            this.m_20334_(-x, y, -z);
            this.decBounces();
        } else {
            this.m_146870_();
        }
    }

    protected void m_8060_(@NotNull BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (this.getBounces() > 0) {
            double x = this.m_20184_().f_82479_;
            double y = this.m_20184_().f_82480_;
            double z = this.m_20184_().f_82481_;
            switch (pResult.m_82434_()) {
                case UP: 
                case DOWN: {
                    this.m_20334_(x, 0.0 - y, z);
                    break;
                }
                case EAST: 
                case WEST: {
                    this.m_20334_(0.0 - x, y, z);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    this.m_20334_(x, y, 0.0 - z);
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            this.decBounces();
        } else {
            this.m_146870_();
        }
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.getBounces());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.setBounces(additionalData.readInt());
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("bounces", this.getBounces());
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setBounces(tag.m_128451_("bounces"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOUNCES, (Object)1);
    }

    private int getBounces() {
        return (Integer)this.f_19804_.m_135370_(BOUNCES);
    }

    private void decBounces() {
        this.setBounces(this.getBounces() - 1);
    }

    private void setBounces(int bounces) {
        this.f_19804_.m_135381_(BOUNCES, (Object)bounces);
    }
}

