/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.recipe;

import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.recipe.CCRecipes;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeLookup;

public class ScrollMeltingRecipe
implements IMeltingRecipe {
    protected static final LoadableField<Ingredient, ScrollMeltingRecipe> INPUT = IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.input);
    protected static final LoadableField<FluidOutput, ScrollMeltingRecipe> OUTPUT = FluidOutput.Loadable.REQUIRED.requiredField("result", r -> r.output);
    protected static final LoadableField<Integer, ScrollMeltingRecipe> TEMPERATURE = IntLoadable.FROM_ZERO.requiredField("temperature", r -> r.temperature);
    protected static final LoadableField<Integer, ScrollMeltingRecipe> TIME = IntLoadable.FROM_ONE.requiredField("time", r -> r.time);
    protected static final LoadableField<List<FluidOutput>, ScrollMeltingRecipe> BYPRODUCTS = FluidOutput.Loadable.REQUIRED.list(0).defaultField("byproducts", List.of(), r -> r.byproducts);
    public static final RecordLoadable<ScrollMeltingRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, INPUT, OUTPUT, TEMPERATURE, TIME, BYPRODUCTS, ScrollMeltingRecipe::new);
    private final ResourceLocation id;
    protected final String group;
    protected final Ingredient input;
    protected final FluidOutput output;
    protected final int temperature;
    protected final int time;
    protected final List<FluidOutput> byproducts;

    public ScrollMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidOutput output, int temperature, int time, List<FluidOutput> byproducts) {
        this(id, group, input, output, temperature, time, byproducts, true);
    }

    public ScrollMeltingRecipe(ResourceLocation id, String group, Ingredient input, FluidOutput output, int temperature, int time, List<FluidOutput> byproducts, boolean addLookup) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.output = output;
        this.temperature = temperature;
        this.time = time;
        this.byproducts = byproducts;
        if (addLookup) {
            MeltingRecipeLookup.addMeltingFluid((Ingredient)input, (FluidOutput)output, (int)temperature);
        }
    }

    public FluidStack getOutput(IMeltingContainer inv) {
        return new FluidStack(CCFluids.getInkFluidForRarity(ISpellContainer.get((ItemStack)inv.getStack()).getSpellAtIndex(0).getRarity()).get(), 125);
    }

    public int getTemperature(IMeltingContainer iMeltingContainer) {
        return this.temperature;
    }

    public int getTime(IMeltingContainer iMeltingContainer) {
        return 20;
    }

    public boolean matches(IMeltingContainer pContainer, Level pLevel) {
        return pContainer.m_216874_(stack -> stack.m_150930_((Item)ItemRegistry.SCROLL.get()));
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CCRecipes.scrollMeltingSerializer.get();
    }
}

