/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.materials;

import com.snackpirate.constructscasting.ConstructsCasting;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialRenderInfoProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialStatsDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialTraitDataProvider;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.PlatingMaterialStats;
import slimeknights.tconstruct.tools.stats.StatlessMaterialStats;

public class CCMaterials
extends AbstractMaterialDataProvider {
    public static final MaterialId arcanium = CCMaterials.createMaterial("arcanium");
    public static final MaterialId exilite = CCMaterials.createMaterial("exilite");
    public static final MaterialId arcaneCloth = CCMaterials.createMaterial("arcane_cloth");
    public static final MaterialId frozenBone = CCMaterials.createMaterial("frozen_bone");
    public static final MaterialId frostRod = CCMaterials.createMaterial("frosted_rod");
    public static final MaterialId hogskin = CCMaterials.createMaterial("hogskin");
    public static final MaterialId dragonskin = CCMaterials.createMaterial("dragonskin");
    public static final MaterialId rainbowSlime = CCMaterials.createMaterial("rainbowslime");
    public static final MaterialId cosmichalcum = CCMaterials.createMaterial("cosmichalcum");

    public CCMaterials(PackOutput gen) {
        super(gen);
    }

    private static MaterialId createMaterial(String name) {
        return new MaterialId(ConstructsCasting.id(name));
    }

    protected void addMaterials() {
        this.addMaterial(frozenBone, 2, 0, true);
        this.addMaterial(arcaneCloth, 2, 0, true);
        this.addMaterial(arcanium, 3, 0, false);
        this.addMaterial(exilite, 3, 0, false);
        this.addMaterial(frostRod, 3, 0, true);
        this.addMaterial(rainbowSlime, 3, 0, false);
    }

    public String m_6055_() {
        return "Construct's Casting Materials";
    }

    public static class CCMaterialRenderInfo
    extends AbstractMaterialRenderInfoProvider {
        public CCMaterialRenderInfo(PackOutput gen, @Nullable AbstractMaterialSpriteProvider materialSprites, ExistingFileHelper fileHelper) {
            super(gen, materialSprites, fileHelper);
        }

        protected void addMaterialRenderInfo() {
            this.buildRenderInfo((MaterialVariantId)arcanium).color(7580638);
            this.buildRenderInfo((MaterialVariantId)arcaneCloth).color(7580638).fallbacks(new String[]{"cloth"});
            this.buildRenderInfo((MaterialVariantId)hogskin).color(0xFF0000).fallbacks(new String[]{"cloth", "primitive"});
            this.buildRenderInfo((MaterialVariantId)exilite).color(4671819);
            this.buildRenderInfo((MaterialVariantId)frozenBone).color(13690340).fallbacks(new String[]{"bone", "rock"});
            this.buildRenderInfo((MaterialVariantId)rainbowSlime).color(0xFFFF00);
            this.buildRenderInfo((MaterialVariantId)frostRod).color(0xC8ECEC).fallbacks(new String[]{"metal", "primitive"});
            this.buildRenderInfo((MaterialVariantId)cosmichalcum).color(0x111081).fallbacks(new String[]{"metal"});
        }

        public String m_6055_() {
            return "Construct's Casting Material Render Info";
        }
    }

    public static class CCMaterialTraits
    extends AbstractMaterialTraitDataProvider {
        public CCMaterialTraits(PackOutput gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        protected void addMaterialTraits() {
            this.addTraits(arcanium, MaterialRegistry.MELEE_HARVEST, new ModifierId[]{CCModifiers.ARCANE});
            this.addTraits(arcanium, MaterialRegistry.ARMOR, new ModifierEntry[]{new ModifierEntry(CCModifiers.ARCANE, 2)});
            this.addTraits(cosmichalcum, MaterialRegistry.MELEE_HARVEST, new ModifierId[]{CCModifiers.ENDER_UPGRADE});
            this.addTraits(cosmichalcum, MaterialRegistry.ARMOR, new ModifierId[]{CCModifiers.ENDER_UPGRADE});
            this.addDefaultTraits(arcaneCloth, new ModifierId[]{CCModifiers.SPELLBOUND});
            this.addDefaultTraits(hogskin, new ModifierId[]{CCModifiers.ARCANE});
            this.addDefaultTraits(frozenBone, new LazyModifier[]{CCModifiers.ANTIFROST});
            this.addDefaultTraits(dragonskin, new ModifierId[]{CCModifiers.ENDER_UPGRADE});
            this.addTraits(frostRod, HandleMaterialStats.ID, new ModifierEntry[]{new ModifierEntry(CCModifiers.ICE_UPGRADE, 1)});
            this.addTraits(exilite, MaterialRegistry.MELEE_HARVEST, new LazyModifier[]{CCModifiers.ANTIMAGIC});
            this.addTraits(exilite, MaterialRegistry.ARMOR, new ModifierId[]{CCModifiers.SPELL_PROTECTION});
            this.noTraits(rainbowSlime);
        }

        public String m_6055_() {
            return "Construct's Casting Material Traits";
        }
    }

    public static class CCMaterialStats
    extends AbstractMaterialStatsDataProvider {
        public CCMaterialStats(PackOutput gen, AbstractMaterialDataProvider materials) {
            super(gen, materials);
        }

        protected void addMaterialStats() {
            this.addMaterialStats(arcanium, new IMaterialStats[]{new HeadMaterialStats(380, 7.0f, (Tier)Tiers.DIAMOND, 2.0f), new HandleMaterialStats(0.05f, 0.1f, -0.05f, -0.15f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 288, 2.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 428, 6.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 400, 5.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 344, 2.0f, 2.0f, 0.1f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 484, 1.0f, 2.0f, 0.1f), StatlessMaterialStats.MAILLE});
            this.addMaterialStats(exilite, new IMaterialStats[]{new HeadMaterialStats(480, 7.5f, (Tier)Tiers.DIAMOND, 2.5f), new HandleMaterialStats(-0.05f, -0.15f, 0.15f, 0.1f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 318, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 458, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 430, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 374, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 514, 1.0f, 2.0f, 0.15f), StatlessMaterialStats.MAILLE});
            this.addMaterialStats(cosmichalcum, new IMaterialStats[]{new HeadMaterialStats(480, 7.5f, (Tier)Tiers.DIAMOND, 2.5f), new HandleMaterialStats(-0.05f, -0.15f, 0.15f, 0.1f), StatlessMaterialStats.BINDING, new PlatingMaterialStats(PlatingMaterialStats.HELMET, 318, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.CHESTPLATE, 458, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.LEGGINGS, 430, 6.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.BOOTS, 374, 2.0f, 2.0f, 0.15f), new PlatingMaterialStats(PlatingMaterialStats.SHIELD, 514, 1.0f, 2.0f, 0.15f), StatlessMaterialStats.MAILLE});
            this.addMaterialStats(frozenBone, new IMaterialStats[]{new HeadMaterialStats(175, 4.0f, (Tier)Tiers.IRON, 2.5f), new HandleMaterialStats(0.1f, -0.05f, -0.1f, 0.1f), StatlessMaterialStats.BINDING});
            this.addMaterialStats(frostRod, new IMaterialStats[]{new HandleMaterialStats(0.1f, -0.1f, -0.15f, 0.15f)});
            this.addMaterialStats(arcaneCloth, new IMaterialStats[]{StatlessMaterialStats.BINDING, StatlessMaterialStats.MAILLE, StatlessMaterialStats.BOWSTRING});
            this.addMaterialStats(hogskin, new IMaterialStats[]{StatlessMaterialStats.BINDING, StatlessMaterialStats.MAILLE, StatlessMaterialStats.BOWSTRING});
            this.addMaterialStats(dragonskin, new IMaterialStats[]{StatlessMaterialStats.BINDING, StatlessMaterialStats.MAILLE, StatlessMaterialStats.BOWSTRING});
            this.addMaterialStats(rainbowSlime, new IMaterialStats[0]);
        }

        public String m_6055_() {
            return "Construct's Casting Material Stats";
        }
    }
}

