/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.item.SpellBook;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.SafeClientAccess;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.capability.inventory.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;
import top.theillusivec4.curios.api.SlotContext;

public class TinkerersSpellbookItem
extends SpellBook
implements IModifiableDisplay {
    private final ToolDefinition definition;
    private ItemStack toolForRendering;

    public TinkerersSpellbookItem(Item.Properties prop, int slots, ToolDefinition definition) {
        super(slots, SpellRarity.EPIC, prop);
        this.definition = definition;
    }

    public ToolDefinition getToolDefinition() {
        return this.definition;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> lines, @NotNull TooltipFlag flag) {
        super.m_7373_(itemStack, level, lines, flag);
        TooltipUtil.addInformation((IModifiableDisplay)this, (ItemStack)itemStack, (Level)level, lines, (TooltipKey)SafeClientAccess.getTooltipKey(), (TooltipFlag)flag);
    }

    public ItemStack getRenderTool() {
        if (this.toolForRendering == null) {
            this.toolForRendering = ToolBuildHandler.buildToolForRendering((Item)this, (ToolDefinition)this.getToolDefinition());
        }
        return this.toolForRendering;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ToolCapabilityProvider(stack);
    }

    public void m_142312_(CompoundTag pCompoundTag) {
        ToolStack.verifyTag((Item)this, (CompoundTag)pCompoundTag, (ToolDefinition)this.getToolDefinition());
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        ToolStack.ensureInitialized((ItemStack)pStack, (ToolDefinition)this.getToolDefinition());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        ToolStack tool = ToolStack.from((ItemStack)stack);
        for (ModifierEntry entry : tool.getModifierList()) {
            ((AttributesModifierHook)entry.getHook(ModifierHooks.ATTRIBUTES)).addAttributes((IToolStackView)tool, entry, EquipmentSlot.MAINHAND, (arg_0, arg_1) -> ((ImmutableMultimap.Builder)attributeBuilder).put(arg_0, arg_1));
        }
        return attributeBuilder.build();
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return ToolStack.from((ItemStack)stack).getModifierLevel(CCModifiers.ENCYCLOPEDIC.getId()) < 1;
    }

    protected static boolean shouldInteract(@Nullable LivingEntity player, ToolStack toolStack, InteractionHand hand) {
        IModDataView volatileData = toolStack.getVolatileData();
        if (volatileData.getBoolean(NO_INTERACTION)) {
            return false;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return true;
        }
        return player == null || !volatileData.getBoolean(DEFER_OFFHAND) || player.m_21206_().m_41619_();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (stack.m_41613_() > 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        ToolStack tool = ToolStack.from((ItemStack)stack);
        if (TinkerersSpellbookItem.shouldInteract((LivingEntity)playerIn, tool, hand)) {
            for (ModifierEntry entry : tool.getModifierList()) {
                InteractionResult result = ((GeneralInteractionModifierHook)entry.getHook(ModifierHooks.GENERAL_INTERACT)).onToolUse((IToolStackView)tool, entry, playerIn, hand, InteractionSource.RIGHT_CLICK);
                if (!result.m_19077_()) continue;
                return new InteractionResultHolder(result, (Object)stack);
            }
        }
        return new InteractionResultHolder(ToolInventoryCapability.tryOpenContainer((ItemStack)stack, (IToolStackView)tool, (Player)playerIn, (EquipmentSlot)Util.getSlotType((InteractionHand)hand)), (Object)stack);
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        ToolStack.ensureInitialized((ItemStack)stack, (ToolDefinition)this.getToolDefinition());
    }
}

