/*
 * Decompiled with CFR 0.152.
 */
package com.snackpirate.constructscasting;

import com.mojang.logging.LogUtils;
import com.snackpirate.constructscasting.CCDamageTypes;
import com.snackpirate.constructscasting.CCLang;
import com.snackpirate.constructscasting.CCSounds;
import com.snackpirate.constructscasting.fluids.CCFluidEffects;
import com.snackpirate.constructscasting.fluids.CCFluids;
import com.snackpirate.constructscasting.items.CCItems;
import com.snackpirate.constructscasting.items.CCTools;
import com.snackpirate.constructscasting.materials.CCMaterialTextures;
import com.snackpirate.constructscasting.materials.CCMaterials;
import com.snackpirate.constructscasting.modifiers.CCModifiers;
import com.snackpirate.constructscasting.recipe.CCRecipes;
import com.snackpirate.constructscasting.spells.CCEntities;
import com.snackpirate.constructscasting.spells.CCSpells;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;
import slimeknights.mantle.registration.deferred.SynchronizedDeferredRegister;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractPartSpriteProvider;
import slimeknights.tconstruct.library.client.data.material.MaterialPartTextureGenerator;
import slimeknights.tconstruct.tools.data.sprite.TinkerPartSpriteProvider;

@Mod(value="constructs_casting")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConstructsCasting {
    public static final String MOD_ID = "constructs_casting";
    protected static final SynchronizedDeferredRegister<CreativeModeTab> CREATIVE_TABS = SynchronizedDeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"constructs_casting");
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("main", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.constructs_casting.constructs_casting")).m_257737_(() -> new ItemStack((ItemLike)CCItems.slimySpellbook.get())).m_257501_(CCItems.DISPLAY_ITEMS).m_257652_());
    public static final Logger LOGGER = LogUtils.getLogger();

    public ConstructsCasting() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        CCModifiers.MODIFIERS.register(modEventBus);
        CCFluids.FLUIDS.register(modEventBus);
        CCFluidEffects.MobEffects.register(modEventBus);
        CCItems.ITEMS.register(modEventBus);
        CCRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        CCSounds.register(modEventBus);
        CCEntities.register(modEventBus);
        CCSpells.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        modEventBus.register((Object)new CCFluids());
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM COMMON SETUP");
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean server = event.includeServer();
        PackOutput output = gen.getPackOutput();
        CCMaterials mats = new CCMaterials(output);
        gen.addProvider(server, (DataProvider)mats);
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture provider = event.getLookupProvider();
        gen.addProvider(server, (DataProvider)new CCTools.CCToolDefinitions(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new MaterialPartTextureGenerator(output, fileHelper, (AbstractPartSpriteProvider)new TinkerPartSpriteProvider(), new AbstractMaterialSpriteProvider[]{new CCMaterialTextures()}));
        gen.addProvider(server, (DataProvider)new CCMaterials.CCMaterialStats(output, mats));
        gen.addProvider(server, (DataProvider)new CCMaterials.CCMaterialRenderInfo(output, new CCMaterialTextures(), fileHelper));
        gen.addProvider(server, (DataProvider)new CCModifiers(output));
        gen.addProvider(server, (DataProvider)new CCMaterials.CCMaterialTraits(output, mats));
        gen.addProvider(server, (DataProvider)new CCItems.Tags(output, provider, CompletableFuture.completedFuture(TagsProvider.TagLookup.m_274566_()), MOD_ID, fileHelper));
        gen.addProvider(server, (DataProvider)new CCFluids.CCFluidTextures(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCFluids.CCBucketModels(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCFluids.Tags(output, provider));
        gen.addProvider(server, (DataProvider)new CCFluids.Tags.CCFluidTooltipProvider(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCRecipes(output));
        gen.addProvider(server, (DataProvider)new CCFluidEffects(output, MOD_ID));
        gen.addProvider(server, (DataProvider)new CCLang(output, MOD_ID, "en_us"));
        gen.addProvider(server, (DataProvider)new CCDamageTypes.Tags(output, provider, MOD_ID, fileHelper));
        gen.addProvider(server, (DataProvider)new CCModifiers.Tags(output, MOD_ID, fileHelper));
    }
}

