/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.multiblock.casing;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.nuclearteam.createnuclear.CNBlockEntityTypes;
import net.nuclearteam.createnuclear.CNBlocks;
import net.nuclearteam.createnuclear.content.multiblock.casing.ReactorCasingEntity;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlock;
import net.nuclearteam.createnuclear.content.multiblock.controller.ReactorControllerBlockEntity;
import net.nuclearteam.createnuclear.content.multiblock.input.ReactorInput;
import net.nuclearteam.createnuclear.foundation.utility.CreateNuclearLang;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ReactorCasing
extends Block
implements IWrenchable,
IBE<ReactorCasingEntity> {
    private final TypeBlock typeBlock;

    public ReactorCasing(BlockBehaviour.Properties properties, TypeBlock tBlock) {
        super(properties);
        this.typeBlock = tBlock;
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        List players = level.m_6907_();
        this.FindController(pos, level, players, true);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        List players = level.m_6907_();
        this.FindController(pos, level, players, false);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.m_6810_(state, level, pos, newState, movedByPiston);
        List players = level.m_6907_();
        this.FindController(pos, level, players, false);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player.m_21120_(InteractionHand.OFF_HAND).m_150930_(Blocks.f_50332_.m_5456_())) {
            level.m_7731_(pos, (BlockState)CNBlocks.REACTOR_INPUT.getDefaultState().m_61124_((Property)ReactorInput.FACING, (Comparable)context.m_43719_()), 2);
            player.m_213846_((Component)Component.m_237115_((String)"reactor.update.casing.input"));
        }
        return InteractionResult.SUCCESS;
    }

    public ReactorControllerBlock FindController(BlockPos blockPos, Level level, List<? extends Player> players, boolean first) {
        Vec3i pos = new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        for (int y = pos.m_123342_() - 3; y != pos.m_123342_() + 4; ++y) {
            for (int x = pos.m_123341_() - 5; x != pos.m_123341_() + 5; ++x) {
                for (int z = pos.m_123343_() - 5; z != pos.m_123343_() + 5; ++z) {
                    BlockPos newBlock = new BlockPos(x, y, z);
                    if (!level.m_8055_(newBlock).m_60713_((Block)CNBlocks.REACTOR_CONTROLLER.get())) continue;
                    ReactorControllerBlock controller = (ReactorControllerBlock)level.m_8055_(newBlock).m_60734_();
                    controller.Verify(level.m_8055_(newBlock), newBlock, level, players, first);
                    ReactorControllerBlockEntity entity = (ReactorControllerBlockEntity)controller.getBlockEntity((BlockGetter)level, newBlock);
                    if (!entity.created) continue;
                    return controller;
                }
            }
        }
        return null;
    }

    public Class<ReactorCasingEntity> getBlockEntityClass() {
        return ReactorCasingEntity.class;
    }

    public BlockEntityType<? extends ReactorCasingEntity> getBlockEntityType() {
        return switch (this.typeBlock) {
            default -> throw new IncompatibleClassChangeError();
            case TypeBlock.CORE -> (BlockEntityType)CNBlockEntityTypes.REACTOR_CORE.get();
            case TypeBlock.CASING -> (BlockEntityType)CNBlockEntityTypes.REACTOR_CASING.get();
        };
    }

    public static enum TypeBlock implements StringRepresentable
    {
        CASING,
        CORE;


        public String m_7912_() {
            return CreateNuclearLang.asId((String)this.name());
        }
    }
}

