/*
 * Decompiled with CFR 0.152.
 */
package net.nuclearteam.createnuclear.content.contraptions.irradiated.cat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.CatLieOnBedGoal;
import net.nuclearteam.createnuclear.content.contraptions.irradiated.cat.CatSitOnBlockGoal;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class IrradiatedCat
extends TamableAnimal {
    public static final double TEMPT_SPEED_MOD = 0.6;
    public static final double WALK_SPEED_MOD = 0.8;
    public static final double SPRINT_SPEED_MOD = 1.33;
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    private static final EntityDataAccessor<Boolean> IS_LYING = SynchedEntityData.m_135353_(IrradiatedCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RELAX_STATE_ONE = SynchedEntityData.m_135353_(IrradiatedCat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(IrradiatedCat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private CatAvoidEntityGoal<Player> avoidPlayersGoal;
    @Nullable
    private TemptGoal temptGoal;
    private float lieDownAmount;
    private float lieDownAmountO;
    private float lieDownAmountTail;
    private float lieDownAmountOTail;
    private float relaxStateOneAmount;
    private float relaxStateOneAmountO;

    public IrradiatedCat(EntityType<? extends IrradiatedCat> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        this.temptGoal = new CatTemptGoal(this, 0.6, TEMPT_INGREDIENT, true);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new CatRelaxOnOwnerGoal(this));
        this.f_21345_.m_25352_(4, (Goal)this.temptGoal);
        this.f_21345_.m_25352_(5, (Goal)new CatLieOnBedGoal(this, 1.1, 8));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new CatSitOnBlockGoal(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.f_21345_.m_25352_(9, (Goal)new OcelotAttackGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(11, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8, 1.0000001E-5f));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Rabbit.class, false, (Predicate)null));
        this.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
    }

    public void setLying(boolean lying) {
        this.f_19804_.m_135381_(IS_LYING, (Object)lying);
    }

    public boolean isLying() {
        return (Boolean)this.f_19804_.m_135370_(IS_LYING);
    }

    public void setRelaxStateOne(boolean relaxStateOne) {
        this.f_19804_.m_135381_(RELAX_STATE_ONE, (Object)relaxStateOne);
    }

    public boolean isRelaxStateOne() {
        return (Boolean)this.f_19804_.m_135370_(RELAX_STATE_ONE);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)color.m_41060_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LYING, (Object)false);
        this.f_19804_.m_135372_(RELAX_STATE_ONE, (Object)false);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
    }

    public void m_8024_() {
        if (this.m_21566_().m_24995_()) {
            double d = this.m_21566_().m_24999_();
            if (d == 0.6) {
                this.m_20124_(Pose.CROUCHING);
                this.m_6858_(false);
            } else if (d == 1.33) {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(true);
            } else {
                this.m_20124_(Pose.STANDING);
                this.m_6858_(false);
            }
        } else {
            this.m_20124_(Pose.STANDING);
            this.m_6858_(false);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_21824_()) {
            if (this.m_27593_()) {
                return SoundEvents.f_11792_;
            }
            return this.f_19796_.m_188503_(4) == 0 ? SoundEvents.f_11793_ : SoundEvents.f_11785_;
        }
        return SoundEvents.f_11786_;
    }

    public int m_8100_() {
        return 120;
    }

    public void hiss() {
        this.m_5496_(SoundEvents.f_11789_, this.m_6121_(), this.m_6100_());
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11791_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11787_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0);
    }

    protected void m_142075_(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            this.m_5496_(SoundEvents.f_11788_, 1.0f, 1.0f);
        }
        super.m_142075_(player, hand, stack);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity target) {
        return target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getAttackDamage());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.temptGoal != null && this.temptGoal.m_25955_() && !this.m_21824_() && this.f_19797_ % 100 == 0) {
            this.m_5496_(SoundEvents.f_11790_, 1.0f, 1.0f);
        }
        this.handleLieDown();
    }

    private void handleLieDown() {
        if ((this.isLying() || this.isRelaxStateOne()) && this.f_19797_ % 5 == 0) {
            this.m_5496_(SoundEvents.f_11792_, 0.6f + 0.4f * (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()), 1.0f);
        }
        this.updateLieDownAmount();
        this.updateRelaxStateOneAmount();
    }

    private void updateLieDownAmount() {
        this.lieDownAmountO = this.lieDownAmount;
        this.lieDownAmountOTail = this.lieDownAmountTail;
        if (this.isLying()) {
            this.lieDownAmount = Math.min(1.0f, this.lieDownAmount + 0.15f);
            this.lieDownAmountTail = Math.min(1.0f, this.lieDownAmountTail + 0.08f);
        } else {
            this.lieDownAmount = Math.max(0.0f, this.lieDownAmount - 0.22f);
            this.lieDownAmountTail = Math.max(0.0f, this.lieDownAmountTail - 0.13f);
        }
    }

    private void updateRelaxStateOneAmount() {
        this.relaxStateOneAmountO = this.relaxStateOneAmount;
        this.relaxStateOneAmount = this.isRelaxStateOne() ? Math.min(1.0f, this.relaxStateOneAmount + 0.1f) : Math.max(0.0f, this.relaxStateOneAmount - 0.13f);
    }

    public float getLieDownAmount(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lieDownAmountO, (float)this.lieDownAmount);
    }

    public float getLieDownAmountTail(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lieDownAmountOTail, (float)this.lieDownAmountTail);
    }

    public float getRelaxStateOneAmount(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.relaxStateOneAmountO, (float)this.relaxStateOneAmount);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        Cat cat = (Cat)EntityType.f_20553_.m_20615_((Level)level);
        if (cat != null && otherParent instanceof Cat) {
            Cat cat2 = (Cat)otherParent;
            if (this.m_21824_()) {
                cat.m_21816_(this.m_21805_());
                cat.m_7105_(true);
                if (this.f_19796_.m_188499_()) {
                    cat.m_28131_(this.getCollarColor());
                } else {
                    cat.m_28131_(cat2.m_28166_());
                }
            }
        }
        return cat;
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof Cat)) {
            return false;
        }
        Cat cat = (Cat)otherAnimal;
        return cat.m_21824_() && super.m_7848_(otherAnimal);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        boolean bl = level.m_46940_() > 0.9f;
        ServerLevel serverLevel = level.m_6018_();
        if (serverLevel.m_215010_().m_220491_(this.m_20183_(), StructureTags.f_215888_).m_73603_()) {
            this.m_21530_();
        }
        return spawnData;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !this.m_6898_(itemStack) || !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (!(item instanceof DyeItem)) {
                    if (item.m_41472_() && this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                        this.m_142075_(player, hand, itemStack);
                        this.m_5634_(item.m_41473_().m_38744_());
                        return InteractionResult.CONSUME;
                    }
                    InteractionResult interactionResult2 = super.m_6071_(player, hand);
                    if (!interactionResult2.m_19077_() || this.m_6162_()) {
                        this.m_21839_(!this.m_21827_());
                    }
                    return interactionResult2;
                }
                DyeColor dyeColor = ((DyeItem)item).m_41089_();
                if (dyeColor != this.getCollarColor()) {
                    this.setCollarColor(dyeColor);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    this.m_21530_();
                    return InteractionResult.CONSUME;
                }
            }
        } else if (this.m_6898_(itemStack)) {
            this.m_142075_(player, hand, itemStack);
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            return InteractionResult.CONSUME;
        }
        if ((interactionResult = super.m_6071_(player, hand)).m_19077_()) {
            this.m_21530_();
        }
        return interactionResult;
    }

    public boolean m_6898_(ItemStack stack) {
        return TEMPT_INGREDIENT.test(stack);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.5f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.m_21824_() && this.f_19797_ > 2400;
    }

    protected void m_5849_() {
        if (this.avoidPlayersGoal == null) {
            this.avoidPlayersGoal = new CatAvoidEntityGoal<Player>(this, Player.class, 16.0f, 0.8, 1.33);
        }
        this.f_21345_.m_25363_(this.avoidPlayersGoal);
        if (!this.m_21824_()) {
            this.f_21345_.m_25352_(4, this.avoidPlayersGoal);
        }
    }

    public boolean m_20161_() {
        return this.m_6047_() || super.m_20161_();
    }

    private static class CatTemptGoal
    extends TemptGoal {
        @Nullable
        private Player selectedPlayer;
        private final IrradiatedCat cat;

        public CatTemptGoal(IrradiatedCat cat, double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)cat, speedModifier, items, canScare);
            this.cat = cat;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.selectedPlayer == null && this.f_25924_.m_217043_().m_188503_(this.m_183277_(600)) == 0) {
                this.selectedPlayer = this.f_25925_;
            } else if (this.f_25924_.m_217043_().m_188503_(this.m_183277_(500)) == 0) {
                this.selectedPlayer = null;
            }
        }

        protected boolean m_7497_() {
            return this.selectedPlayer != null && this.selectedPlayer.equals((Object)this.f_25925_) ? false : super.m_7497_();
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.cat.m_21824_();
        }
    }

    static class CatRelaxOnOwnerGoal
    extends Goal {
        private final IrradiatedCat cat;
        @Nullable
        private Player ownerPlayer;
        @Nullable
        private BlockPos goalPos;
        private int onBedTicks;

        public CatRelaxOnOwnerGoal(IrradiatedCat cat) {
            this.cat = cat;
        }

        public boolean m_8036_() {
            if (!this.cat.m_21824_()) {
                return false;
            }
            if (this.cat.m_21827_()) {
                return false;
            }
            LivingEntity livingEntity = this.cat.m_269323_();
            if (livingEntity instanceof Player) {
                this.ownerPlayer = (Player)livingEntity;
                if (!livingEntity.m_5803_()) {
                    return false;
                }
                if (this.cat.m_20280_((Entity)this.ownerPlayer) > 100.0) {
                    return false;
                }
                BlockPos blockPos = this.ownerPlayer.m_20183_();
                BlockState blockState = this.cat.m_9236_().m_8055_(blockPos);
                if (blockState.m_204336_(BlockTags.f_13038_)) {
                    this.goalPos = blockState.m_61145_((Property)BedBlock.f_54117_).map(direction -> blockPos.m_121945_(direction.m_122424_())).orElseGet(() -> new BlockPos((Vec3i)blockPos));
                    return !this.spaceIsOccupied();
                }
            }
            return false;
        }

        private boolean spaceIsOccupied() {
            IrradiatedCat cat;
            assert (this.goalPos != null);
            List list = this.cat.m_9236_().m_45976_(IrradiatedCat.class, new AABB(this.goalPos).m_82400_(2.0));
            Iterator var2 = list.iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while ((cat = (IrradiatedCat)((Object)var2.next())) == this.cat || !cat.isLying() && !cat.isRelaxStateOne());
            return true;
        }

        public boolean m_8045_() {
            return this.cat.m_21824_() && !this.cat.m_21827_() && this.ownerPlayer != null && this.ownerPlayer.m_5803_() && this.goalPos != null && !this.spaceIsOccupied();
        }

        public void m_8056_() {
            if (this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
            }
        }

        public void m_8041_() {
            this.cat.setLying(false);
            float f = this.cat.m_9236_().m_46942_(1.0f);
            if (this.ownerPlayer.m_36318_() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.m_9236_().m_213780_().m_188501_() < 0.7) {
                this.giveMorningGift();
            }
            this.onBedTicks = 0;
            this.cat.setRelaxStateOne(false);
            this.cat.m_21573_().m_26573_();
        }

        private void giveMorningGift() {
            RandomSource randomSource = this.cat.m_217043_();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            mutableBlockPos.m_122190_((Vec3i)(this.cat.m_21523_() ? this.cat.m_21524_().m_20183_() : this.cat.m_20183_()));
            this.cat.m_20984_(mutableBlockPos.m_123341_() + randomSource.m_188503_(11) - 5, mutableBlockPos.m_123342_() + randomSource.m_188503_(5) - 2, mutableBlockPos.m_123343_() + randomSource.m_188503_(11) - 5, false);
            mutableBlockPos.m_122190_((Vec3i)this.cat.m_20183_());
            LootTable lootTable = this.cat.m_9236_().m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78724_);
            LootParams lootParams = new LootParams.Builder((ServerLevel)this.cat.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)this.cat.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.cat).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList list = lootTable.m_287195_(lootParams);
            for (ItemStack itemStack : list) {
                this.cat.m_9236_().m_7967_((Entity)new ItemEntity(this.cat.m_9236_(), (double)mutableBlockPos.m_123341_() - (double)Mth.m_14031_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), (double)mutableBlockPos.m_123342_(), (double)mutableBlockPos.m_123343_() + (double)Mth.m_14089_((float)(this.cat.f_20883_ * ((float)Math.PI / 180))), itemStack));
            }
        }

        public void m_8037_() {
            if (this.ownerPlayer != null && this.goalPos != null) {
                this.cat.m_21837_(false);
                this.cat.m_21573_().m_26519_((double)this.goalPos.m_123341_(), (double)this.goalPos.m_123342_(), (double)this.goalPos.m_123343_(), (double)1.1f);
                if (this.cat.m_20280_((Entity)this.ownerPlayer) < 2.5) {
                    ++this.onBedTicks;
                    if (this.onBedTicks > this.m_183277_(16)) {
                        this.cat.setLying(true);
                        this.cat.setRelaxStateOne(false);
                    } else {
                        this.cat.m_21391_((Entity)this.ownerPlayer, 45.0f, 45.0f);
                        this.cat.setRelaxStateOne(true);
                    }
                } else {
                    this.cat.setLying(false);
                }
            }
        }
    }

    static class CatAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final IrradiatedCat cat;

        public CatAvoidEntityGoal(IrradiatedCat cat, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)cat, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
            Predicate var10006 = EntitySelector.f_20406_;
            Objects.requireNonNull(var10006);
            this.cat = cat;
        }

        public boolean m_8036_() {
            return !this.cat.m_21824_() && super.m_8036_();
        }

        public boolean m_8045_() {
            return !this.cat.m_21824_() && super.m_8045_();
        }
    }
}

