/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.SmartMesh;

import com.adonis.createfisheryindustry.block.MeshTrap.MeshTrapBlockEntity;
import com.adonis.createfisheryindustry.block.SmartMesh.SmartMeshFilterSlotPositioning;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartMeshBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    protected static final int PROCESSING_TIME = 10;
    private static final int AUTO_EXPORT_COOLDOWN = 20;
    private static final int BELT_EXTRACTION_COOLDOWN = 5;
    protected static final double COLLECTION_RANGE = 1.5;
    private int processingTicks = 0;
    private int autoExportTicks = 0;
    private int beltExtractionTicks = 0;
    private final Map<Direction, TransportedItemStackHandlerBehaviour> beltHandlers = new HashMap<Direction, TransportedItemStackHandlerBehaviour>();
    protected ItemStackHandler inventory = this.createInventory();
    private final LazyOptional<IItemHandler> inventoryCapability = LazyOptional.of(() -> this.inventory);
    private final LazyOptional<IItemHandler> insertionHandler = LazyOptional.of(() -> new InsertionOnlyItemHandler((IItemHandler)this.inventory));
    private final LazyOptional<IItemHandler> extractionHandler = LazyOptional.of(() -> new ExtractionOnlyItemHandler((IItemHandler)this.inventory));
    protected FilteringBehaviour filtering;

    public SmartMeshBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CreateFisheryBlockEntities.SMART_MESH.get(), pos, state);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                SmartMeshBlockEntity.this.m_6596_();
                if (SmartMeshBlockEntity.this.f_58857_ != null && !SmartMeshBlockEntity.this.f_58857_.m_5776_()) {
                    SmartMeshBlockEntity.this.f_58857_.m_7260_(SmartMeshBlockEntity.this.f_58858_, SmartMeshBlockEntity.this.m_58900_(), SmartMeshBlockEntity.this.m_58900_(), 3);
                }
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new SmartMeshFilterSlotPositioning());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SmartMeshBlockEntity be) {
        if (level.m_5776_()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++be.processingTicks;
        if (be.processingTicks >= 10) {
            be.processingTicks = 0;
            be.collectNearbyItems(serverLevel);
            be.m_6596_();
            be.sendData();
            serverLevel.m_7260_(pos, state, state, 3);
        }
        ++be.autoExportTicks;
        if (be.autoExportTicks >= 20) {
            be.autoExportTicks = 0;
            be.tryExportItems(serverLevel);
        }
        ++be.beltExtractionTicks;
        if (be.beltExtractionTicks >= 5) {
            be.beltExtractionTicks = 0;
            be.extractItemsFromBelts(serverLevel);
        }
    }

    protected void collectNearbyItems(ServerLevel level) {
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.5);
        List items = level.m_45976_(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.m_6084_() || (stack = itemEntity.m_32055_()).m_41619_() || !this.canAcceptItem(stack)) continue;
            ItemStack copy = stack.m_41777_();
            if (this.insertItem(copy)) {
                itemEntity.m_146870_();
                continue;
            }
            if (copy.m_41613_() >= stack.m_41613_()) continue;
            itemEntity.m_32045_(copy);
        }
    }

    protected boolean insertItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack remainder = stack.m_41777_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_()) continue;
            return true;
        }
        return stack.m_41613_() != remainder.m_41613_();
    }

    protected void extractItemsFromBelts(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        this.updateBeltHandlers(level);
        for (Direction direction : Direction.values()) {
            TransportedItemStackHandlerBehaviour handler;
            if (direction == Direction.UP || direction == Direction.DOWN || (handler = this.beltHandlers.get(direction)) == null) continue;
            this.extractFromBelt(handler);
        }
    }

    private void updateBeltHandlers(ServerLevel level) {
        this.beltHandlers.clear();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos;
            BlockEntity blockEntity;
            if (direction == Direction.UP || direction == Direction.DOWN || !((blockEntity = level.m_7702_(neighborPos = this.m_58899_().m_121945_(direction))) instanceof SmartBlockEntity)) continue;
            SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
            TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null) continue;
            this.beltHandlers.put(direction, behaviour);
        }
    }

    private void extractFromBelt(TransportedItemStackHandlerBehaviour beltHandler) {
        boolean hasSpace = false;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (!this.inventory.getStackInSlot(slot).m_41619_()) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            return;
        }
        beltHandler.handleCenteredProcessingOnAllItems(0.5f, transportedItem -> {
            ItemStack stack = transportedItem.stack;
            if (stack.m_41619_()) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            if (!this.canAcceptItem(stack)) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            ItemStack remaining = stack.m_41777_();
            boolean anyInserted = false;
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack toInsert;
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                if (!slotStack.m_41619_() && (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)remaining) || slotStack.m_41613_() >= slotStack.m_41741_()) || (remaining = this.inventory.insertItem(slot, toInsert = remaining.m_41777_(), false)).m_41613_() >= toInsert.m_41613_()) continue;
                anyInserted = true;
                if (remaining.m_41619_()) break;
            }
            if (anyInserted) {
                this.m_6596_();
                this.sendData();
                Level patt9436$temp = this.f_58857_;
                if (patt9436$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt9436$temp;
                    serverLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                }
                if (remaining.m_41619_()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                TransportedItemStack newTransportedItem = new TransportedItemStack(remaining);
                newTransportedItem.prevBeltPosition = transportedItem.prevBeltPosition;
                newTransportedItem.beltPosition = transportedItem.beltPosition;
                newTransportedItem.insertedFrom = transportedItem.insertedFrom;
                newTransportedItem.insertedAt = transportedItem.insertedAt;
                return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)newTransportedItem);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
    }

    protected void tryExportItems(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        boolean anyItemMoved = false;
        for (Direction direction : Direction.values()) {
            IItemHandler targetInventory;
            LazyOptional targetCapability;
            BlockPos neighborPos = this.m_58899_().m_121945_(direction);
            TransportedItemStackHandlerBehaviour beltBehaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (beltBehaviour != null || level.m_7702_(neighborPos) instanceof MeshTrapBlockEntity || level.m_7702_(neighborPos) instanceof SmartMeshBlockEntity) continue;
            BlockEntity targetBE = level.m_7702_(neighborPos);
            if (targetBE != null && (targetCapability = targetBE.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_())).isPresent() && (targetInventory = (IItemHandler)targetCapability.orElse(null)) != null) {
                for (int sourceSlot = 0; sourceSlot < this.inventory.getSlots(); ++sourceSlot) {
                    ItemStack stackInSlot = this.inventory.getStackInSlot(sourceSlot);
                    if (stackInSlot.m_41619_()) continue;
                    int extractionAmount = this.getExtractionAmount();
                    ItemHelper.ExtractionCountMode extractionMode = this.getExtractionMode();
                    ItemStack extractedItem = this.inventory.extractItem(sourceSlot, Math.min(stackInSlot.m_41613_(), extractionAmount), true);
                    if (extractedItem.m_41619_()) continue;
                    ItemStack remainingItem = this.insertItemIntoTarget(extractedItem, targetInventory);
                    int actualExtractAmount = extractedItem.m_41613_() - remainingItem.m_41613_();
                    if (actualExtractAmount <= 0) continue;
                    this.inventory.extractItem(sourceSlot, actualExtractAmount, false);
                    anyItemMoved = true;
                    break;
                }
            }
            if (anyItemMoved) break;
        }
        if (anyItemMoved) {
            this.m_6596_();
            this.sendData();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private ItemStack insertItemIntoTarget(ItemStack stack, IItemHandler targetInventory) {
        ItemStack remaining = stack.m_41777_();
        for (int slot = 0; slot < targetInventory.getSlots() && !remaining.m_41619_(); ++slot) {
            remaining = targetInventory.insertItem(slot, remaining, false);
        }
        return remaining;
    }

    protected boolean canAcceptItem(ItemStack stack) {
        boolean canAccept = this.filtering.test(stack);
        return canAccept;
    }

    protected int getExtractionAmount() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() ? this.filtering.getAmount() : 64;
    }

    protected ItemHelper.ExtractionCountMode getExtractionMode() {
        return this.filtering.isCountVisible() && !this.filtering.anyAmount() && !this.filtering.upTo ? ItemHelper.ExtractionCountMode.EXACTLY : ItemHelper.ExtractionCountMode.UPTO;
    }

    public void dropInventory() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.m_82512_((Vec3i)this.f_58858_);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                serverLevel.m_7967_((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.smart_mesh_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.m_237115_((String)stack.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("ProcessingTicks", this.processingTicks);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        this.processingTicks = compound.m_128451_("ProcessingTicks");
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCapability.invalidate();
        this.insertionHandler.invalidate();
        this.extractionHandler.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack) && this.canAcceptItem(stack);
        }

        private boolean canAcceptItem(ItemStack stack) {
            if (this.wrapped instanceof ItemStackHandler) {
                for (int i = 0; i < this.wrapped.getSlots(); ++i) {
                    ItemStack slotStack = this.wrapped.getStackInSlot(i);
                    if (!slotStack.m_41619_() && (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)stack) || slotStack.m_41613_() >= slotStack.m_41741_())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

