/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.TriConsumer;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.MekanismPermissions;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityData;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.network.to_client.PacketSecurityUpdate;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.OwnerDisplay;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class SecurityUtils
implements ISecurityUtils {
    public static SecurityUtils get() {
        return (SecurityUtils)INSTANCE;
    }

    private boolean isOp(Player p) {
        ServerPlayer player;
        Objects.requireNonNull(p, "Player may not be null.");
        return MekanismConfig.general.opsBypassRestrictions.get() && p instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)(player = (ServerPlayer)p), MekanismPermissions.BYPASS_SECURITY, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
    }

    @Override
    @Nullable
    public UUID getOwnerUUID(ICapabilityProvider provider) {
        Objects.requireNonNull(provider, "Capability provider may not be null.");
        return provider.getCapability(Capabilities.OWNER_OBJECT).resolve().map(IOwnerObject::getOwnerUUID).orElse(null);
    }

    @Override
    public boolean canAccess(Player player, @Nullable ICapabilityProvider provider) {
        return this.isOp(player) || this.canAccess(player.m_20148_(), provider, player.m_9236_().f_46443_);
    }

    @Override
    public boolean canAccessObject(Player player, ISecurityObject security) {
        return this.isOp(player) || this.canAccessObject(player.m_20148_(), security, player.m_9236_().f_46443_);
    }

    @Override
    public boolean canAccess(@Nullable UUID player, @Nullable ICapabilityProvider provider, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get() || provider == null) {
            return true;
        }
        Optional securityCapability = provider.getCapability(Capabilities.SECURITY_OBJECT).resolve();
        if (securityCapability.isEmpty()) {
            Optional ownerCapability = provider.getCapability(Capabilities.OWNER_OBJECT).resolve();
            if (ownerCapability.isPresent()) {
                UUID owner = ((IOwnerObject)ownerCapability.get()).getOwnerUUID();
                return owner == null || owner.equals(player);
            }
            return true;
        }
        return this.canAccessObject(player, (ISecurityObject)securityCapability.get(), isClient);
    }

    @Override
    public boolean canAccessObject(@Nullable UUID player, @NotNull ISecurityObject security, boolean isClient) {
        Objects.requireNonNull(security, "Security object may not be null.");
        if (!MekanismConfig.general.allowProtection.get()) {
            return true;
        }
        UUID owner = security.getOwnerUUID();
        if (owner == null || owner.equals(player)) {
            return true;
        }
        return switch (this.getEffectiveSecurityMode(security, isClient)) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> true;
            case SecurityMode.PRIVATE -> false;
            case SecurityMode.TRUSTED -> {
                if (player == null) {
                    yield false;
                }
                if (isClient) {
                    yield true;
                }
                SecurityFrequency frequency = FrequencyType.SECURITY.getManager(null).getFrequency(owner);
                if (frequency != null && frequency.getTrustedUUIDs().contains(player)) {
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public boolean moreRestrictive(SecurityMode base, SecurityMode overridden) {
        Objects.requireNonNull(base, "Base security mode may not be null.");
        Objects.requireNonNull(base, "Override security mode may not be null.");
        return switch (overridden) {
            default -> throw new IncompatibleClassChangeError();
            case SecurityMode.PUBLIC -> false;
            case SecurityMode.PRIVATE -> {
                if (base != SecurityMode.PRIVATE) {
                    yield true;
                }
                yield false;
            }
            case SecurityMode.TRUSTED -> base == SecurityMode.PUBLIC;
        };
    }

    public SecurityData getFinalData(ISecurityObject securityObject, boolean isClient) {
        if (!MekanismConfig.general.allowProtection.get()) {
            return SecurityData.DUMMY;
        }
        SecurityData data = this.getData(securityObject.getOwnerUUID(), isClient);
        SecurityMode mode = securityObject.getSecurityMode();
        if (data.override() && this.moreRestrictive(mode, data.mode())) {
            return data;
        }
        return new SecurityData(mode, false);
    }

    private SecurityData getData(@Nullable UUID uuid, boolean isClient) {
        if (uuid == null) {
            return SecurityData.DUMMY;
        }
        if (isClient) {
            return MekanismClient.clientSecurityMap.getOrDefault(uuid, SecurityData.DUMMY);
        }
        SecurityFrequency frequency = FrequencyType.SECURITY.getManager(null).getFrequency(uuid);
        return frequency == null ? SecurityData.DUMMY : new SecurityData(frequency);
    }

    @Override
    public SecurityMode getSecurityMode(@Nullable ICapabilityProvider provider, boolean isClient) {
        if (provider == null || !MekanismConfig.general.allowProtection.get()) {
            return SecurityMode.PUBLIC;
        }
        return provider.getCapability(Capabilities.SECURITY_OBJECT).map(security -> this.getEffectiveSecurityMode((ISecurityObject)security, isClient)).orElseGet(() -> provider.getCapability(Capabilities.OWNER_OBJECT).isPresent() ? SecurityMode.PRIVATE : SecurityMode.PUBLIC);
    }

    @Override
    public SecurityMode getEffectiveSecurityMode(ISecurityObject securityObject, boolean isClient) {
        Objects.requireNonNull(securityObject, "Security object may not be null.");
        return this.getFinalData(securityObject, isClient).mode();
    }

    public void incrementSecurityMode(Player player, ICapabilityProvider provider) {
        provider.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(security -> {
            if (security.ownerMatches(player)) {
                security.setSecurityMode((SecurityMode)security.getSecurityMode().getNext());
            }
        });
    }

    public void decrementSecurityMode(Player player, ICapabilityProvider provider) {
        provider.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(security -> {
            if (security.ownerMatches(player)) {
                security.setSecurityMode((SecurityMode)security.getSecurityMode().getPrevious());
            }
        });
    }

    public InteractionResultHolder<ItemStack> claimOrOpenGui(Level level, Player player, InteractionHand hand, TriConsumer<ServerPlayer, InteractionHand, ItemStack> openGui) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.tryClaimItem(level, player, stack)) {
            if (!this.canAccessOrDisplayError(player, (ICapabilityProvider)stack)) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (!level.f_46443_) {
                openGui.accept((ServerPlayer)player, hand, stack);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public boolean tryClaimItem(Level level, Player player, ItemStack stack) {
        IOwnerObject ownerObject;
        Optional capability = stack.getCapability(Capabilities.OWNER_OBJECT).resolve();
        if (capability.isPresent() && (ownerObject = (IOwnerObject)capability.get()).getOwnerUUID() == null) {
            if (!level.f_46443_) {
                ownerObject.setOwnerUUID(player.m_20148_());
                Mekanism.packetHandler().sendToAll(new PacketSecurityUpdate(player.m_20148_()));
                player.m_213846_(MekanismUtils.logFormat(MekanismLang.NOW_OWN));
            }
            return true;
        }
        return false;
    }

    @Override
    public void displayNoAccess(Player player) {
        Objects.requireNonNull(player, "Player may not be null.");
        player.m_213846_(MekanismUtils.logFormat(EnumColor.RED, MekanismLang.NO_ACCESS));
    }

    public void addOwnerTooltip(ItemStack stack, List<Component> tooltip) {
        stack.getCapability(Capabilities.OWNER_OBJECT).ifPresent(ownerObject -> tooltip.add(OwnerDisplay.of(MekanismUtils.tryGetClientPlayer(), ownerObject.getOwnerUUID()).getTextComponent()));
    }

    @Override
    public void addSecurityTooltip(ItemStack stack, List<Component> tooltip) {
        Objects.requireNonNull(stack, "Stack to add tooltip for may not be null.");
        Objects.requireNonNull(tooltip, "List of tooltips to add to may not be null.");
        this.addOwnerTooltip(stack, tooltip);
        stack.getCapability(Capabilities.SECURITY_OBJECT).ifPresent(security -> {
            SecurityData data = this.getFinalData((ISecurityObject)security, true);
            tooltip.add((Component)MekanismLang.SECURITY.translateColored(EnumColor.GRAY, data.mode()));
            if (data.override()) {
                tooltip.add((Component)MekanismLang.SECURITY_OVERRIDDEN.translateColored(EnumColor.RED, new Object[0]));
            }
        });
    }

    public void securityChanged(Set<Player> playersUsing, ICapabilityProvider target, SecurityMode old, SecurityMode mode) {
        if (this.moreRestrictive(old, mode) && !playersUsing.isEmpty()) {
            for (Player player : new ObjectOpenHashSet(playersUsing)) {
                if (this.canAccess(player, target)) continue;
                player.m_6915_();
            }
        }
    }
}

