/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.TrainDestinationCompactSettings;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERTrainDestinationSimple
implements AbstractAdvancedDisplayRenderer<TrainDestinationCompactSettings> {
    private final Component TEXT_OUT_OF_SERVICE = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.not_in_service");
    private final Component TEXT_DO_NOT_BOARD = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.do_not_board");
    private final BERLabel outOfServiceLabel = new BERLabel(this.TEXT_OUT_OF_SERVICE).setPos(3.0f, 6.0f).setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);
    private final BERLabel trainLineLabel = new BERLabel().setScale(0.6f, 0.3f).setYScale(0.8f);
    private final BERLabel destinationLabel = new BERLabel().setScale(0.5f, 0.25f).setYScale(0.5f).setCentered(true).setScrollingSpeed(2.0f);

    @Override
    public void renderTick(float deltaTime) {
        this.trainLineLabel.renderTick();
        this.destinationLabel.renderTick();
        this.outOfServiceLabel.renderTick();
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isIrregular()) {
            this.outOfServiceLabel.render(graphics, light);
            return;
        }
        DLUtils.doIfNotNull((Object)this.trainLineLabel, x -> x.render((RenderGraphics)graphics, light));
        DLUtils.doIfNotNull((Object)this.destinationLabel, x -> x.render((RenderGraphics)graphics, light));
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isIrregular()) {
            this.outOfServiceLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setText(blockEntity.getTrainData() != null && blockEntity.getTrainData().getState().shouldNotBoard() ? this.TEXT_DO_NOT_BOARD : this.TEXT_OUT_OF_SERVICE);
            return;
        }
        this.updateContent(blockEntity);
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity) {
        TrainDestinationCompactSettings settings = (TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity);
        byte width = settings.getTrainNameWidth();
        this.trainLineLabel.setPos(3.0f, 5.0f).setText((Component)(width == 0 ? TextUtils.empty() : TextUtils.text((String)blockEntity.getTrainData().getTrainData().getName()).m_130940_(ChatFormatting.BOLD))).setMaxWidth(settings.isFullTrainNameWidth() ? (float)(blockEntity.getXSizeScaled() * 16 - 6) : (float)(settings.isAutoTrainNameWidth() ? 12 : Math.min(((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getTrainNameWidth(), blockEntity.getXSizeScaled() * 16 - 6)), settings.isAutoTrainNameWidth() ? BERLabel.BoundsHitReaction.IGNORE : BERLabel.BoundsHitReaction.SCALE_SCROLL).setCentered(settings.isFullTrainNameWidth());
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor()) {
            this.trainLineLabel.setBackground(0xFF000000 | blockEntity.getTrainData().getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)blockEntity.getTrainData().getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            this.trainLineLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        this.destinationLabel.setPos((settings.isAutoTrainNameWidth() ? this.trainLineLabel.getTextWidth() : (float)width) + 5.0f, 6.0f).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16) - this.destinationLabel.getX() - 3.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setText((Component)(settings.isFullTrainNameWidth() ? TextUtils.empty() : TextUtils.text((String)(blockEntity.getTrainData().getCurrentStop().isPresent() ? blockEntity.getTrainData().getCurrentStop().get().getDestination() : "")))).setColor(0xFF000000 | ((TrainDestinationCompactSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }
}

