/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IPlatformWidthSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowArrivalSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainNameWidthSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class PlatformDisplayTableSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
ITrainNameWidthSetting,
IPlatformWidthSetting,
IShowArrivalSetting,
IShowLineColorSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected byte trainNameWidth = (byte)16;
    protected byte platformWidth = (byte)-1;
    protected boolean showArrival = true;
    protected boolean showLineColor = false;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.m_128441_("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.m_128445_("TimeDisplay"));
        }
        if (nbt.m_128441_("TrainNameWidth")) {
            this.trainNameWidth = nbt.m_128445_("TrainNameWidth");
        }
        if (nbt.m_128441_("PlatformWidth")) {
            this.platformWidth = nbt.m_128445_("PlatformWidth");
        }
        if (nbt.m_128441_("ShowArrival")) {
            this.showArrival = nbt.m_128471_("ShowArrival");
        }
        if (nbt.m_128441_("ShowLineColor")) {
            this.showLineColor = nbt.m_128471_("ShowLineColor");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.m_128344_("TimeDisplay", this.timeDisplay.getId());
        nbt.m_128344_("TrainNameWidth", this.trainNameWidth);
        nbt.m_128344_("PlatformWidth", this.platformWidth);
        nbt.m_128379_("ShowArrival", this.showArrival);
        nbt.m_128379_("ShowLineColor", this.showLineColor);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildTrainNameGui(context, true, false);
        this.buildPlatformWidthGui(context, true);
        this.buildShowArrivalGui(context);
        this.buildShowLineColorGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyTrainNameSetting(oldSettings);
        this.copyPlatformWidthSetting(oldSettings);
        this.copyShowArrivalSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public byte getPlatformWidth() {
        return this.platformWidth;
    }

    @Override
    public void setPlatformWidth(byte b) {
        this.platformWidth = b;
    }

    @Override
    public byte getTrainNameWidth() {
        return this.trainNameWidth;
    }

    @Override
    public void setTrainNameWidth(byte b) {
        this.trainNameWidth = b;
    }

    @Override
    public boolean showArrival() {
        return this.showArrival;
    }

    @Override
    public void setShowArrival(boolean b) {
        this.showArrival = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }
}

