/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.windchest;

import com.finchy.pipeorgans.content.windchest.WindchestBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlock;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WindchestMasterBlock
extends Block
implements IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WINDY = BooleanProperty.m_61465_((String)"windy");

    public WindchestMasterBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WINDY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, POWERED, WINDY});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        Direction facing = pContext.m_8125_();
        return (BlockState)((BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)(pContext.m_43723_().m_6144_() ? facing.m_122424_() : facing))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(clickedPos)));
    }

    public void updateSlaves(BlockState state, Level level, BlockPos pos, boolean powered) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos currentPos = pos;
        for (int i = 0; i <= 12; ++i) {
            BlockState currentBlock = level.m_8055_(currentPos = currentPos.m_121945_(facing));
            if (!(currentBlock.m_60734_() instanceof WindchestBlock) || currentBlock.m_61143_((Property)FACING) != facing.m_122424_()) {
                return;
            }
            level.m_7731_(currentPos, (BlockState)currentBlock.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        if (pPos.m_121945_((Direction)pState.m_61143_((Property)FACING)).equals((Object)pNeighborPos)) {
            return;
        }
        boolean previouslyPowered = (Boolean)pState.m_61143_((Property)POWERED);
        boolean powered = false;
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        for (Direction i : Direction.values()) {
            if (i == facing || pLevel.m_277185_(pPos.m_121945_(i), i) <= 0) continue;
            powered = true;
            break;
        }
        if (previouslyPowered != powered) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
            this.updateSlaves(pState, pLevel, pPos, powered);
        }
        if (pNeighborBlock instanceof EncasedFanBlock) {
            WindchestMasterBlock.updateMasterWindy(pLevel, pPos);
        }
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pMovedByPiston) {
        if (pLevel.f_46443_) {
            return;
        }
        this.updateSlaves(pState, pLevel, pPos, pLevel.m_276867_(pPos));
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pLevel.f_46443_) {
            return;
        }
        this.updateSlaves(pState, pLevel, pPos, false);
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public static boolean updateMasterWindy(Level level, BlockPos masterPos) {
        if (level.f_46443_) {
            return false;
        }
        int activeFans = 0;
        for (Direction d : Iterate.directions) {
            EncasedFanBlockEntity fanBE;
            BlockState fanState;
            BlockEntity blockEntity = level.m_7702_(masterPos.m_121945_(d));
            if (!(blockEntity instanceof EncasedFanBlockEntity) || (fanState = (fanBE = (EncasedFanBlockEntity)blockEntity).m_58900_()).m_61143_((Property)EncasedFanBlock.FACING) != d.m_122424_() || !(fanBE.getSpeed() * (float)d.m_122421_().m_122540_() < 0.0f)) continue;
            ++activeFans;
        }
        level.m_7731_(masterPos, (BlockState)level.m_8055_(masterPos).m_61124_((Property)WINDY, (Comparable)Boolean.valueOf(activeFans > 0)), 2);
        return activeFans > 0;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

