/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.pipes.generic;

import com.finchy.pipeorgans.content.pipes.generic.GenericExtensionBlock;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockEntity;
import com.finchy.pipeorgans.content.pipes.generic.GenericPipeBlockItem;
import com.finchy.pipeorgans.content.pipes.generic.GenericWhistleProperties;
import com.finchy.pipeorgans.content.pipes.generic.subtypes.PedalPipeBlock;
import com.finchy.pipeorgans.content.windchest.WindchestBlock;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericPipeBlock
extends Block
implements IBE<GenericPipeBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WALL = BooleanProperty.m_61465_((String)"wall");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final EnumProperty<GenericWhistleProperties.WhistleSize> SIZE = EnumProperty.m_61587_((String)"size", GenericWhistleProperties.WhistleSize.class);
    public GenericWhistleProperties.WhistleShape shape;
    public int extensionsPerBlock;
    public RegistryObject<? extends GenericPipeBlock> baseBlock;
    public RegistryObject<? extends GenericExtensionBlock> extensionBlock;
    public RegistryObject<BlockEntityType> blockEntity;

    public GenericPipeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(false))).m_61124_(SIZE, (Comparable)((Object)GenericWhistleProperties.WhistleSize.MEDIUM)));
        this.shape = GenericWhistleProperties.WhistleShape.GENERIC;
        this.extensionsPerBlock = 2;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.getCompleteWhistleShape((GenericWhistleProperties.WhistleSize)((Object)pState.m_61143_(SIZE)), this.shape, (Boolean)pState.m_61143_((Property)WALL), (Direction)pState.m_61143_((Property)FACING));
    }

    public Class<GenericPipeBlockEntity> getBlockEntityClass() {
        return GenericPipeBlockEntity.class;
    }

    public BlockEntityType<? extends GenericPipeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)this.blockEntity.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)this.blockEntity.get()).m_155264_(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, WALL, POWERED, SIZE});
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (heldItem.m_41720_() == ((GenericPipeBlock)((Object)this.baseBlock.get())).m_5456_()) {
            this.incrementSize((LevelAccessor)pLevel, pPos);
            return InteractionResult.SUCCESS;
        }
        if (heldItem.m_41720_() instanceof GenericPipeBlockItem) {
            GenericPipeBlock held = (GenericPipeBlock)((GenericPipeBlockItem)heldItem.m_41720_()).m_40614_();
            if (this.substitutePipe(pState, pLevel, pPos, held)) {
                if (!pPlayer.m_7500_()) {
                    heldItem.m_41774_(1);
                    pPlayer.m_21008_(pHand, heldItem);
                    pPlayer.m_150109_().m_150079_(new ItemStack((ItemLike)((GenericPipeBlock)((Object)this.baseBlock.get())).m_5456_()));
                }
                return InteractionResult.SUCCESS;
            }
            AllSoundEvents.DENY.playOnServer(pLevel, (Vec3i)pPos);
            pPlayer.m_5661_((Component)Component.m_237115_((String)"pipeorgans.blocks.pipes.replace_pipe_deny"), true);
        }
        return InteractionResult.PASS;
    }

    public boolean substitutePipe(BlockState state, Level level, BlockPos pos, GenericPipeBlock held) {
        GenericPipeBlock base = (GenericPipeBlock)state.m_60734_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GenericPipeBlockEntity) {
            GenericPipeBlockEntity be = (GenericPipeBlockEntity)blockEntity;
            if (held.extensionsPerBlock >= base.extensionsPerBlock) {
                int removeDist = (int)Math.ceil((float)be.pitch / (float)base.extensionsPerBlock);
                BlockPos currentPos = pos;
                for (int i = 1; i <= removeDist; ++i) {
                    currentPos = currentPos.m_7494_();
                    level.m_46961_(currentPos, false);
                }
                this.placeNewPipe(state, level, pos, held, be.pitch);
            } else {
                if (be.pitch > 0) {
                    int checkDist = (int)Math.ceil((float)be.pitch / (float)held.extensionsPerBlock);
                    BlockPos currentPos = pos;
                    for (int i = 1; i <= checkDist; ++i) {
                        BlockState currentState = level.m_8055_(currentPos = currentPos.m_7494_());
                        if (currentState.m_247087_() || currentState.m_60734_() instanceof GenericExtensionBlock) continue;
                        return false;
                    }
                    int removeDist = (int)Math.ceil((float)be.pitch / (float)base.extensionsPerBlock);
                    currentPos = pos;
                    for (int i = 1; i <= removeDist; ++i) {
                        currentPos = currentPos.m_7494_();
                        level.m_46961_(currentPos, false);
                    }
                }
                this.placeNewPipe(state, level, pos, held, be.pitch);
            }
        }
        return true;
    }

    public void incrementSize(LevelAccessor pLevel, BlockPos pPos) {
        this.incrementSize(pLevel, pPos, true);
    }

    public void incrementSize(LevelAccessor pLevel, BlockPos pPos, boolean playSound) {
        BlockState base = pLevel.m_8055_(pPos);
        if (!base.m_61138_(SIZE)) {
            return;
        }
        GenericWhistleProperties.WhistleSize size = (GenericWhistleProperties.WhistleSize)((Object)base.m_61143_(SIZE));
        SoundType soundtype = base.m_60827_();
        BlockPos currentPos = pPos.m_7494_();
        Direction facing = (Direction)base.m_61143_((Property)FACING);
        float pVolume = (soundtype.m_56773_() + 1.0f) / 2.0f;
        SoundEvent growSound = (SoundEvent)SoundEvents.f_12218_.get();
        SoundEvent hitSound = soundtype.m_56778_();
        for (int i = 1; i <= 6; ++i) {
            BlockState blockState = pLevel.m_8055_(currentPos);
            if (blockState.m_60734_() instanceof GenericExtensionBlock) {
                if (blockState.m_61143_(GenericExtensionBlock.SHAPE) == GenericWhistleProperties.QuadrupleExtensionShape.DOUBLE) {
                    pLevel.m_7731_(currentPos, (BlockState)((BlockState)blockState.m_61124_(GenericExtensionBlock.SHAPE, (Comparable)((Object)GenericWhistleProperties.QuadrupleExtensionShape.QUAD))).m_61124_((Property)FACING, (Comparable)facing), 3);
                    if (playSound) {
                        float pPitch = (float)Math.pow(2.0, (double)(-(i * 2)) / 12.0);
                        pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                        pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                    }
                    return;
                }
            } else {
                if (!blockState.m_247087_()) {
                    return;
                }
                pLevel.m_7731_(currentPos, (BlockState)((BlockState)((GenericExtensionBlock)((Object)this.extensionBlock.get())).m_49966_().m_61124_(SIZE, (Comparable)((Object)size))).m_61124_((Property)FACING, (Comparable)facing), 3);
                if (playSound) {
                    float pPitch = (float)Math.pow(2.0, (double)(-(i * 2 - 1)) / 12.0);
                    pLevel.m_5594_(null, currentPos, growSound, SoundSource.BLOCKS, pVolume / 4.0f, pPitch);
                    pLevel.m_5594_(null, currentPos, hitSound, SoundSource.BLOCKS, pVolume, pPitch);
                }
                return;
            }
            currentPos = currentPos.m_7494_();
        }
    }

    public void placeNewPipe(BlockState state, Level level, BlockPos pos, GenericPipeBlock pipe, int pitch) {
        GenericWhistleProperties.WhistleSize size = (GenericWhistleProperties.WhistleSize)((Object)state.m_61143_(SIZE));
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean wall = (Boolean)state.m_61143_((Property)WALL);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (pipe instanceof PedalPipeBlock && size == GenericWhistleProperties.WhistleSize.TINY) {
            size = GenericWhistleProperties.WhistleSize.SMALL;
        }
        level.m_46961_(pos, false);
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)pipe.m_49966_().m_61124_(SIZE, (Comparable)((Object)size))).m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(wall))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        GenericPipeBlock newPipe = (GenericPipeBlock)level.m_8055_(pos).m_60734_();
        if (pitch > 0) {
            for (int i = 1; i <= pitch; ++i) {
                newPipe.incrementSize((LevelAccessor)level, pos);
            }
        }
    }

    public static void queuePitchUpdate(LevelAccessor level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof GenericPipeBlock) {
            GenericPipeBlock whistle = (GenericPipeBlock)block;
            if (!level.m_183326_().m_183582_(pos, (Object)whistle)) {
                level.m_186460_(pos, (Block)whistle, 1);
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, GenericPipeBlockEntity::updatePitch);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState attachedState = pLevel.m_8055_(pPos.m_121945_(GenericPipeBlock.getAttachedDirection(pState)));
        return FluidTankBlock.isTank((BlockState)attachedState) || attachedState.m_60734_() instanceof WindchestBlock;
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.m_61122_(SIZE);
    }

    public static Direction getAttachedDirection(BlockState state) {
        return (Boolean)state.m_61143_((Property)WALL) != false ? (Direction)state.m_61143_((Property)FACING) : Direction.DOWN;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction face = context.m_43719_();
        boolean wall = true;
        if (face.m_122434_() == Direction.Axis.Y) {
            face = context.m_8125_().m_122424_();
            wall = false;
        }
        if (!this.m_7898_(state = (BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)FACING, (Comparable)face.m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(level.m_276867_(clickedPos)))).m_61124_((Property)WALL, (Comparable)Boolean.valueOf(wall)), (LevelReader)level, clickedPos)) {
            return null;
        }
        return state;
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean isMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)pState.m_61143_((Property)POWERED);
        if (previouslyPowered != pLevel.m_276867_(pPos)) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return GenericPipeBlock.getAttachedDirection(pState) == pFacing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : pState;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.m_121945_(GenericPipeBlock.getAttachedDirection(pState)));
        if (pOldState.m_60734_() != this || pOldState.m_61143_(SIZE) != pState.m_61143_(SIZE)) {
            GenericPipeBlock.queuePitchUpdate((LevelAccessor)pLevel, pPos);
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        FluidTankBlock.updateBoilerState((BlockState)pState, (Level)pLevel, (BlockPos)pPos.m_121945_(GenericPipeBlock.getAttachedDirection(pState)));
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pMirror == Mirror.NONE ? pState : pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }
}

