/*
 * Decompiled with CFR 0.152.
 */
package com.finchy.pipeorgans.content.midi.keyboardRelay;

import com.finchy.pipeorgans.content.midi.keyboardRelay.KeyboardRelayBlockEntity;
import com.finchy.pipeorgans.content.midi.stopMaster.StopMasterBlockItem;
import com.finchy.pipeorgans.init.AllBlockEntities;
import com.finchy.pipeorgans.init.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KeyboardRelayBlock
extends Block
implements IBE<KeyboardRelayBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KeyboardRelayBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AllShapes.KBR.get((Direction)pState.m_61143_((Property)FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction facing = pContext.m_8125_().m_122424_();
        return (BlockState)Objects.requireNonNull(super.m_5573_(pContext)).m_61124_((Property)FACING, (Comparable)facing);
    }

    public Class<KeyboardRelayBlockEntity> getBlockEntityClass() {
        return KeyboardRelayBlockEntity.class;
    }

    public BlockEntityType<? extends KeyboardRelayBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntities.KEYBOARD_RELAY_BLOCK_ENTITY.get();
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.PASS;
        }
        if (pHand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResult.PASS;
        }
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof StopMasterBlockItem) {
            return InteractionResult.PASS;
        }
        if (KeyboardRelayBlockEntity.playerInRange(pPlayer, pLevel, pPos)) {
            if (!KeyboardRelayBlockEntity.playerIsUsing(pPlayer)) {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.tryStartUsing(pPlayer));
            } else {
                this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> be.tryStopUsing(pPlayer));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.m_60713_(pNewState.m_60734_()) && !pLevel.f_46443_) {
            this.withBlockEntityDo((BlockGetter)pLevel, pPos, KeyboardRelayBlockEntity::onBlockRemoved);
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

