/*
 * Decompiled with CFR 0.152.
 */
package pyre.tinkerslevellingaddon.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import pyre.tinkerslevellingaddon.network.ClientPacketHandler;

public class LevelUpPacket {
    private final int level;
    private final Component toolName;

    public LevelUpPacket(int level, Component toolName) {
        this.level = level;
        this.toolName = toolName;
    }

    public LevelUpPacket(FriendlyByteBuf buf) {
        this.level = buf.readInt();
        this.toolName = buf.m_130238_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.level);
        buf.m_130083_(this.toolName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handleLevelUpMessage(this.level, this.toolName)));
        return true;
    }
}

