/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.corelib.CachedMap;
import de.maxhenkel.easypiglins.corelib.client.ItemRenderer;
import de.maxhenkel.easypiglins.corelib.client.RendererProviders;
import de.maxhenkel.easypiglins.corelib.item.ItemUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockItemRendererBase<T extends BlockEntityRenderer<U>, U extends FakeWorldTileentity>
extends ItemRenderer {
    private Function<BlockEntityRendererProvider.Context, T> rendererSupplier;
    private Supplier<U> tileEntitySupplier;
    private T renderer;
    private Minecraft minecraft;
    private CachedMap<ItemStack, U> cachedMap;

    public BlockItemRendererBase(Function<BlockEntityRendererProvider.Context, T> rendererSupplier, Supplier<U> tileentitySupplier) {
        this.rendererSupplier = rendererSupplier;
        this.tileEntitySupplier = tileentitySupplier;
        this.cachedMap = new CachedMap(10000L, ItemUtils.ITEM_COMPARATOR);
        this.minecraft = Minecraft.m_91087_();
    }

    @Override
    public void renderByItem(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (this.renderer == null) {
            this.renderer = (BlockEntityRenderer)this.rendererSupplier.apply(RendererProviders.createBlockEntityRendererContext());
        }
        CompoundTag blockEntityTag = itemStack.m_41737_("BlockEntityTag");
        FakeWorldTileentity tileEntity = this.cachedMap.get(itemStack, () -> {
            FakeWorldTileentity te = (FakeWorldTileentity)((Object)((Object)this.tileEntitySupplier.get()));
            te.setFakeWorld((Level)this.minecraft.f_91073_);
            if (blockEntityTag != null) {
                te.m_142466_(blockEntityTag);
            }
            return te;
        });
        this.renderer.m_6922_((BlockEntity)tileEntity, 0.0f, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

