/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.MultiItemStackHandler;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.ModBlocks;
import de.maxhenkel.easypiglins.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easypiglins.blocks.tileentity.PiglinTileentity;
import de.maxhenkel.easypiglins.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easypiglins.corelib.inventory.ItemListInventory;
import de.maxhenkel.easypiglins.corelib.item.ItemUtils;
import de.maxhenkel.easypiglins.gui.BarterSlot;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class BartererTileentity
extends PiglinTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    @Nullable
    protected NonNullList<ItemStack> itemsLeft;
    protected ItemStack barteringItem = ItemStack.f_41583_;
    protected int barteringTimeLeft;
    protected LazyOptional<MultiItemStackHandler> itemHandler = LazyOptional.of(() -> new MultiItemStackHandler(this.inputInventory, this.outputInventory, BarterSlot::isValid));
    protected ItemStackHandler outputHandler = new ItemStackHandler(this.outputInventory);

    public BartererTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.BARTERER.get(), ((BartererBlock)ModBlocks.BARTERER.get()).m_49966_(), pos, state);
    }

    @Override
    public void tickServer() {
        Piglin p = this.getPiglinEntity();
        if (p == null) {
            return;
        }
        if (this.f_58857_.m_46467_() % 20L == 0L && this.f_58857_.f_46441_.m_188503_(40) == 0) {
            BartererBlock.playPiglinSound(this.f_58857_, this.f_58858_, SoundEvents.f_12239_);
        }
        if (this.itemsLeft == null) {
            ItemStack oldBarteringItem = this.barteringItem;
            this.barteringItem = this.removeBarteringItem();
            if (!this.barteringItem.m_41619_()) {
                if (this.f_58857_.m_213780_().m_188503_(5) == 0) {
                    BartererBlock.playPiglinSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12238_);
                }
                this.itemsLeft = this.generateLoot(p);
                this.barteringTimeLeft = 120;
                this.m_6596_();
                this.sync();
            } else if (!oldBarteringItem.equals(this.barteringItem)) {
                this.sync();
            }
        }
        if (this.barteringTimeLeft <= 0) {
            this.insertItems();
        } else {
            --this.barteringTimeLeft;
            this.m_6596_();
        }
    }

    public ItemStack removeBarteringItem() {
        for (ItemStack stack : this.inputInventory) {
            if (!stack.isPiglinCurrency() || stack.m_41613_() < 1) continue;
            return stack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getRenderBarteringItem() {
        return this.barteringItem;
    }

    private NonNullList<ItemStack> generateLoot(Piglin piglin) {
        LootTable loottable = this.f_58857_.m_7654_().m_278653_().m_278676_(BuiltInLootTables.f_78738_);
        ObjectArrayList loot = loottable.m_287195_(new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81455_, (Object)piglin).m_287235_(LootContextParamSets.f_81417_));
        NonNullList result = NonNullList.m_122779_();
        result.addAll((Collection)loot);
        return result;
    }

    private void insertItems() {
        if (this.itemsLeft == null) {
            return;
        }
        NonNullList newLeft = NonNullList.m_122779_();
        for (ItemStack drop : this.itemsLeft) {
            for (int i = 0; i < this.outputHandler.getSlots() && !(drop = this.outputHandler.insertItem(i, drop, false)).m_41619_(); ++i) {
            }
            if (drop.m_41619_()) continue;
            newLeft.add((Object)drop);
        }
        if (newLeft.isEmpty()) {
            this.itemsLeft = null;
            this.sync();
        } else {
            this.itemsLeft = newLeft;
        }
        this.m_6596_();
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("InputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
        if (this.itemsLeft != null) {
            ItemUtils.saveItemList(compound, "ItemsLeft", this.itemsLeft);
        }
        if (!this.barteringItem.m_41619_()) {
            compound.m_128365_("BarteringItem", (Tag)this.barteringItem.m_41739_(new CompoundTag()));
        }
        compound.m_128405_("BarteringTimeLeft", this.barteringTimeLeft);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.inputInventory.clear();
        this.outputInventory.clear();
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("InputInventory"), this.inputInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
        this.itemsLeft = compound.m_128441_("ItemsLeft") ? ItemUtils.readItemList(compound, "ItemsLeft", false) : null;
        this.barteringItem = compound.m_128441_("BarteringItem") ? ItemStack.m_41712_((CompoundTag)compound.m_128469_("BarteringItem")) : ItemStack.f_41583_;
        this.barteringTimeLeft = compound.m_128451_("BarteringTimeLeft");
        super.m_142466_(compound);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((BartererTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((BartererTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        super.m_7651_();
    }
}

