/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.misc;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public class CaveBookProgress {
    public static final String PLAYER_CAVE_BOOK_PROGRESS_TAG = "AlexsCavesBookProgress";
    private Map<String, Subcategory> unlockedPages = new HashMap<String, Subcategory>();

    private CaveBookProgress(CompoundTag tag) {
        if (tag.m_128441_("Pages")) {
            ListTag listTag = tag.m_128437_("Pages", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundtag = listTag.m_128728_(i);
                this.unlockedPages.put(compoundtag.m_128461_("Category"), Subcategory.getByOrdinal(compoundtag.m_128451_("SubCategory")));
            }
        }
    }

    public static CaveBookProgress getCaveBookProgress(Player player) {
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        CompoundTag tag1 = tag.m_128441_(PLAYER_CAVE_BOOK_PROGRESS_TAG) ? tag.m_128469_(PLAYER_CAVE_BOOK_PROGRESS_TAG) : new CompoundTag();
        return new CaveBookProgress(tag1);
    }

    public static void saveCaveBookProgress(CaveBookProgress caveBookProgress, Player player) {
        CompoundTag savedTag = caveBookProgress.save();
        CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)player);
        tag.m_128365_(PLAYER_CAVE_BOOK_PROGRESS_TAG, (Tag)savedTag);
        CitadelEntityData.setCitadelTag((LivingEntity)player, (CompoundTag)tag);
        if (!player.m_9236_().f_46443_) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelTagUpdate", tag, player.m_19879_()));
        } else {
            Citadel.sendMSGToServer((Object)new PropertiesMessage("CitadelTagUpdate", tag, player.m_19879_()));
        }
    }

    private CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<String, Subcategory> entry : this.unlockedPages.entrySet()) {
            CompoundTag innerTag = new CompoundTag();
            innerTag.m_128359_("Category", entry.getKey());
            innerTag.m_128405_("SubCategory", entry.getValue().ordinal());
            listTag.add((Object)innerTag);
        }
        tag.m_128365_("Pages", (Tag)listTag);
        return tag;
    }

    public boolean unlockNextFor(String biomeCategory) {
        int prev = this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY).ordinal();
        if (prev >= Subcategory.values().length - 1) {
            return false;
        }
        if (Subcategory.canUnlockNext(biomeCategory, prev)) {
            Subcategory unlocked = (Boolean)AlexsCaves.COMMON_CONFIG.onlyOneResearchNeeded.get() != false ? Subcategory.getLastUnlockableFor(biomeCategory) : Subcategory.getByOrdinal(prev + 1);
            this.unlockedPages.put(biomeCategory, unlocked);
            return true;
        }
        return false;
    }

    public boolean isUnlockedFor(String biomeCategory, Subcategory subcategory) {
        int prev = this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY).ordinal();
        return subcategory.ordinal() <= prev;
    }

    public Subcategory getLastUnlockedCategory(String biomeCategory) {
        return this.unlockedPages.getOrDefault(biomeCategory, Subcategory.EMPTY);
    }

    public boolean isUnlockedFor(String key) {
        Subcategory subcategory = this.getSubcategoryFromPage(key);
        String biomeCategory = this.getBiomeFromPage(key);
        return this.isUnlockedFor(biomeCategory, subcategory);
    }

    public String getBiomeFromPage(String key) {
        int lastIndexOfUnderscore = key.lastIndexOf("_");
        if (lastIndexOfUnderscore >= 0 && lastIndexOfUnderscore + 1 < key.length()) {
            return key.substring(0, lastIndexOfUnderscore);
        }
        return "";
    }

    public Subcategory getSubcategoryFromPage(String key) {
        int lastIndexOfUnderscore = key.lastIndexOf("_");
        if (lastIndexOfUnderscore >= 0 && lastIndexOfUnderscore + 1 < key.length()) {
            String subCatStr = key.substring(lastIndexOfUnderscore + 1);
            return Subcategory.valueOf(subCatStr.toUpperCase(Locale.ROOT));
        }
        return Subcategory.EMPTY;
    }

    public static enum Subcategory {
        EMPTY(new ResourceKey[0]),
        GENERAL(new ResourceKey[0]),
        RESOURCES(new ResourceKey[0]),
        MOBS(new ResourceKey[0]),
        UTILITIES(new ResourceKey[0]),
        SECRETS(ACBiomeRegistry.PRIMORDIAL_CAVES, ACBiomeRegistry.TOXIC_CAVES);

        private final ResourceKey<Biome>[] limitedTo;

        private Subcategory(ResourceKey<Biome> ... limitedTo) {
            this.limitedTo = limitedTo;
        }

        public static Subcategory getByOrdinal(int subCategory) {
            return Subcategory.values()[Mth.m_14045_((int)subCategory, (int)0, (int)(Subcategory.values().length - 1))];
        }

        public static boolean canUnlockNext(String category, int currentLevel) {
            Subcategory next = Subcategory.getByOrdinal(currentLevel + 1);
            return next.limitedTo.length == 0 || Arrays.stream(next.limitedTo).anyMatch(biomeResourceKey -> biomeResourceKey.m_135782_().toString().equals(category));
        }

        public static Subcategory getLastUnlockableFor(String category) {
            Subcategory subcategory = SECRETS;
            if (subcategory.limitedTo.length > 0 && Arrays.stream(subcategory.limitedTo).anyMatch(biomeResourceKey -> biomeResourceKey.m_135782_().toString().equals(category))) {
                return subcategory;
            }
            return Subcategory.getByOrdinal(subcategory.ordinal() - 1);
        }
    }
}

