/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityDataRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ai.NotLavaSwimNodeEvaluator;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.util.GummyColors;
import com.github.alexmodguy.alexscaves.server.entity.util.HasGummyColors;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;

public class SweetishFishEntity
extends WaterAnimal
implements Bucketable,
HasGummyColors {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(SweetishFishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<GummyColors> GUMMY_COLOR = SynchedEntityData.m_135353_(SweetishFishEntity.class, (EntityDataSerializer)((EntityDataSerializer)ACEntityDataRegistry.GUMMY_COLOR.get()));
    private float landProgress;
    private float prevLandProgress;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;

    public SweetishFishEntity(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.7f, 10.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(GUMMY_COLOR, (Object)GummyColors.RED);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 4.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level){

            protected PathFinder m_5532_(int p_26598_) {
                this.f_26508_ = new NotLavaSwimNodeEvaluator(true);
                return new PathFinder(this.f_26508_, p_26598_);
            }

            public boolean m_26574_() {
                return SweetishFishEntity.this.isInLiquid();
            }
        };
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_7296_(int i) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public static boolean checkSweetishFishSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return spawnType == MobSpawnType.SPAWNER || !level.m_6425_(pos).m_76178_() && level.m_6425_(pos).getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
        compound.m_128405_("GummyColor", this.getGummyColor().ordinal());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
        this.setGummyColor(GummyColors.fromOrdinal(compound.m_128451_("GummyColor")));
    }

    private boolean isInLiquid() {
        return this.m_20072_() || this.isInSoda();
    }

    private boolean isInSoda() {
        return this.getFluidTypeHeight((FluidType)ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get()) > 0.0;
    }

    protected void m_6229_(int prevAir) {
        if (this.m_6084_() && !this.isInLiquid()) {
            this.m_20301_(prevAir - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(400);
        }
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(400);
    }

    public ItemStack m_28282_() {
        ItemStack stack = switch (this.getGummyColor()) {
            case GummyColors.RED -> new ItemStack((ItemLike)ACItemRegistry.SWEETISH_FISH_RED_BUCKET.get());
            case GummyColors.GREEN -> new ItemStack((ItemLike)ACItemRegistry.SWEETISH_FISH_GREEN_BUCKET.get());
            case GummyColors.YELLOW -> new ItemStack((ItemLike)ACItemRegistry.SWEETISH_FISH_YELLOW_BUCKET.get());
            case GummyColors.BLUE -> new ItemStack((ItemLike)ACItemRegistry.SWEETISH_FISH_BLUE_BUCKET.get());
            default -> new ItemStack((ItemLike)ACItemRegistry.SWEETISH_FISH_PINK_BUCKET.get());
        };
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        InteractionResult type = super.m_6071_(player, hand);
        if (!type.m_19077_() && itemstack.m_41720_() == ACItemRegistry.PURPLE_SODA_BUCKET.get() && this.m_6084_()) {
            this.m_5496_(this.m_142623_(), 1.0f, 1.0f);
            ItemStack itemstack1 = this.m_28282_();
            this.m_6872_(itemstack1);
            ItemStack itemstack2 = ItemUtils.m_41817_((ItemStack)itemstack, (Player)player, (ItemStack)itemstack1, (boolean)false);
            player.m_21008_(hand, itemstack2);
            if (!this.m_9236_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, itemstack1);
            }
            this.m_146870_();
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return type;
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.prevLandProgress = this.landProgress;
        this.prevFishPitch = this.fishPitch;
        boolean bl = grounded = !this.isInLiquid();
        if (grounded && this.landProgress < 5.0f) {
            this.landProgress += 1.0f;
        }
        if (!grounded && this.landProgress > 0.0f) {
            this.landProgress -= 1.0f;
        }
        if (grounded && this.m_6084_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_((SoundEvent)ACSoundRegistry.SWEETISH_FISH_FLOP.get(), this.m_6121_(), this.m_6100_());
        }
        float pitchTarget = (float)this.m_20184_().f_82480_ * 3.0f;
        if (grounded) {
            pitchTarget = 0.0f;
        }
        this.fishPitch = Mth.m_14148_((float)this.fishPitch, (float)(Mth.m_14036_((float)pitchTarget, (float)-1.4f, (float)1.4f) * -57.295776f), (float)5.0f);
    }

    public float getLandProgress(float partialTicks) {
        return (this.prevLandProgress + (this.landProgress - this.prevLandProgress) * partialTicks) * 0.2f;
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    @Override
    public GummyColors getGummyColor() {
        return (GummyColors)((Object)this.f_19804_.m_135370_(GUMMY_COLOR));
    }

    public void setGummyColor(GummyColors color) {
        this.f_19804_.m_135381_(GUMMY_COLOR, (Object)color);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.isInLiquid()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            if (!this.m_20096_()) {
                delta = delta.m_82520_(0.0, -0.009, 0.0);
            }
            this.m_20256_(delta.m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setGummyColor(GummyColors.getRandom(this.f_19796_, true));
        return super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && effectInstance.m_19544_() != MobEffects.f_19612_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.SWEETISH_FISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.SWEETISH_FISH_HURT.get();
    }

    private class WanderGoal
    extends Goal {
        private BlockPos target;
        private int timeout = 0;

        private WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        private boolean isLiquidAt(BlockPos pos) {
            FluidState state = SweetishFishEntity.this.m_9236_().m_6425_(pos);
            return state.m_205070_(FluidTags.f_13131_) || state.getFluidType() == ACFluidRegistry.PURPLE_SODA_FLUID_TYPE.get();
        }

        private BlockPos findMoveToPos() {
            BlockPos fishPos = SweetishFishEntity.this.m_20183_();
            for (int i = 0; i < 15; ++i) {
                BlockPos offset = fishPos.m_7918_(SweetishFishEntity.this.f_19796_.m_188503_(10) - 5, 0, SweetishFishEntity.this.f_19796_.m_188503_(10) - 5);
                while (this.isLiquidAt(offset) && offset.m_123342_() < SweetishFishEntity.this.m_9236_().m_151558_()) {
                    offset = offset.m_7494_();
                }
                if (this.isLiquidAt(offset) || !this.isLiquidAt(offset.m_7495_())) continue;
                BlockPos surface = offset.m_7495_();
                return this.isLiquidAt(surface = surface.m_6625_(SweetishFishEntity.this.f_19796_.m_188503_(4))) ? surface : null;
            }
            return null;
        }

        public boolean m_8036_() {
            BlockPos found;
            if (!SweetishFishEntity.this.isInLiquid()) {
                return false;
            }
            if (SweetishFishEntity.this.f_19796_.m_188503_(4) == 0 && (found = this.findMoveToPos()) != null) {
                this.target = found;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return SweetishFishEntity.this.isInLiquid() && !SweetishFishEntity.this.f_21344_.m_26571_() && this.timeout < 40;
        }

        public void m_8041_() {
            this.timeout = 0;
        }

        public void m_8056_() {
            this.timeout = 0;
            SweetishFishEntity.this.m_21573_().m_26519_((double)((float)this.target.m_123341_() + 0.5f), (double)((float)this.target.m_123342_() + 0.25f), (double)((float)this.target.m_123343_() + 0.5f), 1.0);
        }

        public void m_8037_() {
            ++this.timeout;
        }
    }
}

