/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.PlayMessages;

public class DarkArrowEntity
extends AbstractArrow {
    private float fadeOut = 0.0f;
    private float prevFadeOut = 0.0f;
    private boolean startFading = false;
    private float arrowR = 0.0f;
    private float prevArrowR = 0.0f;
    private static final EntityDataAccessor<Float> SHADOW_ARROW_DAMAGE = SynchedEntityData.m_135353_(DarkArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> PERFECT_SHOT = SynchedEntityData.m_135353_(DarkArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public DarkArrowEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public DarkArrowEntity(Level level, LivingEntity shooter) {
        super((EntityType)ACEntityRegistry.DARK_ARROW.get(), shooter, level);
    }

    public DarkArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)ACEntityRegistry.DARK_ARROW.get(), x, y, z, level);
    }

    public DarkArrowEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.DARK_ARROW.get(), level);
        this.m_20011_(this.m_142242_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHADOW_ARROW_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PERFECT_SHOT, (Object)false);
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void m_36799_() {
        this.f_36703_ = false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevArrowR = this.arrowR;
        this.prevFadeOut = this.fadeOut;
        if (this.f_36703_) {
            this.startFading = true;
        }
        if (this.startFading) {
            this.f_19794_ = true;
            this.m_20256_(this.m_20184_().m_82490_((double)0.7f));
            float f = this.fadeOut;
            this.fadeOut = f + 1.0f;
            if (f > 5.0f) {
                this.m_146870_();
            }
        }
        if (this.isPerfectShot() && this.arrowR < 1.0f) {
            this.arrowR = Math.min(this.arrowR + 0.15f, 1.0f);
        }
    }

    protected float m_6882_() {
        return 0.9f;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        float damage = this.getShadowArrowDamage();
        if (this.isPerfectShot()) {
            damage *= 2.0f;
        }
        DamageSource damageSource = ACDamageTypes.causeDarkArrowDamage(entity.m_9236_().m_9598_(), owner);
        if (!(owner != null && (entity.m_7306_(owner) || entity.m_7307_(owner) || owner.m_7307_(entity)) || this.startFading || !entity.m_6469_(damageSource, damage))) {
            this.startFading = true;
        }
    }

    public float getShadowArrowDamage() {
        return ((Float)this.f_19804_.m_135370_(SHADOW_ARROW_DAMAGE)).floatValue();
    }

    public void setShadowArrowDamage(float f) {
        this.f_19804_.m_135381_(SHADOW_ARROW_DAMAGE, (Object)Float.valueOf(f));
    }

    public void setPerfectShot(boolean b) {
        this.f_19804_.m_135381_(PERFECT_SHOT, (Object)b);
    }

    public boolean isPerfectShot() {
        return (Boolean)this.f_19804_.m_135370_(PERFECT_SHOT);
    }

    public float getFadeOut(float partialTicks) {
        return this.prevFadeOut + (this.fadeOut - this.prevFadeOut) * partialTicks;
    }

    public float getArrowRed(float partialTicks) {
        return this.prevArrowR + (this.arrowR - this.prevArrowR) * partialTicks;
    }
}

