/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class WatcherAttackGoal
extends Goal {
    private WatcherEntity watcher;
    private int navigationCheckCooldown = 0;
    private int possessions = 0;
    private boolean canReachViaGround = false;
    private int retreatFor = 0;
    private Vec3 retreatTo = null;

    public WatcherAttackGoal(WatcherEntity watcher) {
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.watcher = watcher;
    }

    public boolean m_8036_() {
        LivingEntity target = this.watcher.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8037_() {
        LivingEntity target = this.watcher.m_5448_();
        if (this.navigationCheckCooldown-- < 0) {
            this.calculateReach();
        }
        if (target != null && target.m_6084_()) {
            double dist = this.watcher.m_20270_((Entity)target);
            this.watcher.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            if (this.retreatFor-- > 0) {
                if (this.retreatTo == null) {
                    this.retreatFor = 0;
                } else {
                    Vec3 retreatVec = this.retreatTo.m_82546_(this.watcher.m_20182_());
                    if (retreatVec.m_82553_() > 1.0) {
                        retreatVec = retreatVec.m_82541_();
                        this.watcher.m_20256_(this.watcher.m_20184_().m_82549_(retreatVec.m_82490_((double)0.2f)));
                        this.watcher.setShadeMode(true);
                    } else {
                        this.retreatTo = null;
                    }
                }
            } else {
                if (!this.canReachViaGround && !this.watcher.isShadeMode() && this.watcher.m_20096_()) {
                    this.watcher.setShadeMode(true);
                }
                this.watcher.setShadeMode(!this.canReachViaGround);
                if (dist < 6.0 && this.watcher.m_142582_((Entity)target) && this.watcher.m_20096_()) {
                    this.watcher.setShadeMode(false);
                }
                if (dist > (double)(target.m_20205_() + this.watcher.m_20205_() + 0.5f)) {
                    this.watcher.m_21573_().m_5624_((Entity)target, (double)(this.watcher.isRunning() ? 1.3f : 1.0f) + Math.min(Math.log(this.possessions + 1), 1.0) * (double)0.6f);
                } else {
                    if (this.watcher.m_142582_((Entity)target)) {
                        if (this.watcher.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                            this.watcher.setAnimation(this.watcher.m_217043_().m_188499_() ? WatcherEntity.ANIMATION_ATTACK_0 : WatcherEntity.ANIMATION_ATTACK_1);
                            this.watcher.m_216990_((SoundEvent)ACSoundRegistry.WATCHER_ATTACK.get());
                        } else if (this.watcher.getAnimationTick() == 8) {
                            target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.watcher), (float)this.watcher.m_21051_(Attributes.f_22281_).m_22135_());
                            target.m_147240_(0.5, this.watcher.m_20185_() - target.m_20185_(), this.watcher.m_20189_() - target.m_20189_());
                            this.retreatFor = 30 + this.watcher.m_217043_().m_188503_(30);
                            for (int i = 0; i < 15; ++i) {
                                Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.watcher, (int)30, (int)15, (Vec3)target.m_20182_());
                                if (vec3 == null) continue;
                                this.retreatTo = vec3;
                                break;
                            }
                        }
                    }
                    this.watcher.m_21573_().m_26573_();
                }
            }
            if (this.possessions > 2 || dist < 20.0) {
                this.watcher.setRunning(true);
            }
            if (this.watcher.attemptPossession(target)) {
                if (this.watcher.getPossessedEntity() == null) {
                    ++this.possessions;
                }
                this.watcher.setPossessedEntityUUID(target.m_20148_());
            }
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.navigationCheckCooldown = 0;
        this.possessions = 0;
        this.retreatFor = 0;
        this.retreatTo = null;
    }

    public void calculateReach() {
        LivingEntity target = this.watcher.m_5448_();
        if (target != null && target.m_6084_()) {
            this.canReachViaGround = this.watcher.canReach(target, false);
            this.navigationCheckCooldown = 10 + this.watcher.m_217043_().m_188503_(40);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.watcher.setShadeMode(false);
        this.watcher.setRunning(false);
        this.retreatFor = 0;
        this.retreatTo = null;
    }
}

