/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.SauropodBaseEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.citadel.server.entity.pathfinding.raycoms.PathResult;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.Vec3;

public class LuxtructosaurusMeleeGoal
extends Goal {
    private LuxtructosaurusEntity luxtructosaurus;
    private int navigationCheckCooldown = 0;
    private int flamesCooldown = 0;
    private int roarCooldown = 0;
    private int successfulJumpCooldown = 0;

    public LuxtructosaurusMeleeGoal(LuxtructosaurusEntity luxtructosaurus) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.luxtructosaurus = luxtructosaurus;
    }

    public boolean m_8036_() {
        LivingEntity target = this.luxtructosaurus.m_5448_();
        return target != null && target.m_6084_();
    }

    public void m_8056_() {
        this.navigationCheckCooldown = 0;
        this.flamesCooldown = 0;
        this.roarCooldown = 0;
    }

    public void m_8041_() {
        this.luxtructosaurus.turningFast = false;
    }

    public void m_8037_() {
        LivingEntity target = this.luxtructosaurus.m_5448_();
        if (target != null && target.m_6084_()) {
            double distance = this.luxtructosaurus.m_20270_((Entity)target);
            double attackDistance = this.luxtructosaurus.m_20205_() + target.m_20205_();
            boolean farFlag = false;
            if (this.luxtructosaurus.getAnimation() == SauropodBaseEntity.ANIMATION_SPEW_FLAMES || this.luxtructosaurus.getAnimation() == SauropodBaseEntity.ANIMATION_LEFT_KICK || this.luxtructosaurus.getAnimation() == SauropodBaseEntity.ANIMATION_RIGHT_KICK || this.luxtructosaurus.getAnimation() == SauropodBaseEntity.ANIMATION_LEFT_WHIP || this.luxtructosaurus.getAnimation() == SauropodBaseEntity.ANIMATION_RIGHT_WHIP) {
                this.luxtructosaurus.turningFast = true;
                Vec3 vec3 = target.m_20182_().m_82546_(this.luxtructosaurus.m_20182_());
                this.luxtructosaurus.f_20884_ = this.luxtructosaurus.f_20883_ = Mth.m_14148_((float)this.luxtructosaurus.f_20883_, (float)(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f), (float)15.0f);
                this.luxtructosaurus.m_21563_().m_24946_(target.m_20185_(), target.m_20188_(), target.m_20189_());
            } else {
                this.luxtructosaurus.turningFast = false;
            }
            if (distance > attackDistance) {
                this.luxtructosaurus.m_21573_().m_5624_((Entity)target, 1.0);
            }
            if (this.luxtructosaurus.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                int roarRandomChance;
                if (distance < attackDistance + 4.0) {
                    float random = this.luxtructosaurus.m_217043_().m_188501_();
                    if ((double)random < 0.33 && this.luxtructosaurus.m_20096_()) {
                        this.luxtructosaurus.setAnimation(LuxtructosaurusEntity.ANIMATION_STOMP);
                        this.luxtructosaurus.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_ATTACK_STOMP.get(), 3.0f, this.luxtructosaurus.m_6100_());
                    } else if ((double)random < 0.66 && distance < attackDistance + 1.0) {
                        this.luxtructosaurus.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_KICK.get(), 3.0f, this.luxtructosaurus.m_6100_());
                        this.luxtructosaurus.setAnimation(this.luxtructosaurus.m_217043_().m_188499_() ? LuxtructosaurusEntity.ANIMATION_LEFT_KICK : LuxtructosaurusEntity.ANIMATION_RIGHT_KICK);
                    } else {
                        this.luxtructosaurus.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_TAIL.get(), 3.0f, this.luxtructosaurus.m_6100_());
                        this.luxtructosaurus.setAnimation(this.luxtructosaurus.m_217043_().m_188499_() ? LuxtructosaurusEntity.ANIMATION_RIGHT_WHIP : LuxtructosaurusEntity.ANIMATION_LEFT_WHIP);
                    }
                } else {
                    farFlag = true;
                    if (this.luxtructosaurus.isEnraged() && this.flamesCooldown == 0) {
                        this.flamesCooldown = 200 + this.luxtructosaurus.m_217043_().m_188503_(300);
                        this.luxtructosaurus.setAnimation(SauropodBaseEntity.ANIMATION_SPEW_FLAMES);
                    }
                }
                int n = roarRandomChance = farFlag ? 90 : 150;
                if (this.luxtructosaurus.isEnraged()) {
                    roarRandomChance += 200;
                }
                if (this.roarCooldown == 0 && this.luxtructosaurus.m_217043_().m_188503_(roarRandomChance) == 0 || !this.luxtructosaurus.isEnraged() && this.luxtructosaurus.m_21223_() < this.luxtructosaurus.m_21233_() * 0.25f) {
                    this.roarCooldown = 100 + this.luxtructosaurus.m_217043_().m_188503_(200);
                    this.luxtructosaurus.setAnimation(SauropodBaseEntity.ANIMATION_ROAR);
                    this.luxtructosaurus.enragedFor = 500 + this.luxtructosaurus.m_217043_().m_188503_(200);
                    this.luxtructosaurus.setEnraged(true);
                }
            }
            if (this.successfulJumpCooldown <= 0 && this.navigationCheckCooldown-- < 0 && (this.luxtructosaurus.m_20096_() || this.luxtructosaurus.m_20077_())) {
                this.navigationCheckCooldown = 20 + this.luxtructosaurus.m_217043_().m_188503_(40);
                if (!this.canReach(target) && this.luxtructosaurus.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    this.luxtructosaurus.setAnimation(LuxtructosaurusEntity.ANIMATION_JUMP);
                    this.luxtructosaurus.m_5496_((SoundEvent)ACSoundRegistry.LUXTRUCTOSAURUS_JUMP.get(), 5.0f, this.luxtructosaurus.m_6100_());
                    this.luxtructosaurus.jumpTarget = target.m_20182_();
                    this.successfulJumpCooldown = 100 + this.luxtructosaurus.m_217043_().m_188503_(200);
                }
            }
        }
        if (this.flamesCooldown > 0) {
            --this.flamesCooldown;
        }
        if (this.roarCooldown > 0) {
            --this.roarCooldown;
        }
        if (this.successfulJumpCooldown > 0) {
            --this.successfulJumpCooldown;
        }
    }

    private boolean canReach(LivingEntity target) {
        int k;
        int j;
        if (target.m_20270_((Entity)this.luxtructosaurus) > 50.0f) {
            return false;
        }
        PathResult path = ((AdvancedPathNavigate)this.luxtructosaurus.m_21573_()).moveToLivingEntity((Entity)target, 1.0);
        if (path == null || path.getPath() == null) {
            return false;
        }
        Node node = path.getPath().m_77395_();
        if (node == null) {
            return false;
        }
        int i = node.f_77271_ - target.m_146903_();
        return (double)(i * i + (j = node.f_77272_ - target.m_146904_()) * j + (k = node.f_77273_ - target.m_146907_()) * k) <= 3.0;
    }
}

