/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.DinosaurEggBlock;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.LaysEggs;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class AnimalLayEggGoal
extends MoveToBlockGoal {
    private final Animal mob;
    private final LaysEggs laysEggs;
    private final int maxTime;
    private int layEggCounter;

    public AnimalLayEggGoal(Animal mob, int maxTime, double speed) {
        super((PathfinderMob)mob, speed, 16);
        this.mob = mob;
        this.laysEggs = (LaysEggs)this.mob;
        this.maxTime = maxTime;
    }

    public boolean m_8036_() {
        return this.laysEggs.hasEgg() && super.m_8036_();
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.laysEggs.hasEgg();
    }

    public void m_8056_() {
        super.m_8056_();
        this.layEggCounter = 0;
    }

    public double m_8052_() {
        return Math.ceil(this.mob.m_20205_()) + 0.5;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.m_25625_()) {
            this.laysEggs.onLayEggTick(this.f_25602_.m_7494_(), this.layEggCounter);
            if (this.layEggCounter++ > this.maxTime) {
                Level level = this.mob.m_9236_();
                level.m_5594_((Player)null, this.f_25602_, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                BlockPos blockpos1 = this.f_25602_.m_7494_();
                BlockState blockstate = this.laysEggs.createEggBlockState();
                level.m_46597_(blockpos1, blockstate);
                level.m_220407_(GameEvent.f_157797_, blockpos1, GameEvent.Context.m_223719_((Entity)this.mob, (BlockState)blockstate));
                this.laysEggs.setHasEgg(false);
                this.mob.m_27601_(600);
                this.mob.m_9236_().m_7605_((Entity)this.mob, (byte)78);
                Animal animal = this.mob;
                if (animal instanceof DinosaurEntity) {
                    DinosaurEntity dinosaur = (DinosaurEntity)animal;
                    if (level.m_8055_(this.f_25602_).m_204336_(BlockTags.f_144274_)) {
                        level.m_46597_(this.f_25602_, dinosaur.createEggBeddingBlockState());
                    }
                }
            }
        } else {
            this.layEggCounter = 0;
        }
    }

    protected boolean m_6465_(LevelReader levelReader, BlockPos blockPos) {
        Animal animal;
        if (levelReader.m_46859_(blockPos.m_7494_()) && (animal = this.mob) instanceof DinosaurEntity) {
            Block block;
            DinosaurEntity dinosaur = (DinosaurEntity)animal;
            BlockState eggState = dinosaur.createEggBlockState();
            if (eggState != null && (block = eggState.m_60734_()) instanceof DinosaurEggBlock) {
                DinosaurEggBlock dinosaurEggBlock = (DinosaurEggBlock)block;
                return dinosaurEggBlock.isProperHabitat((BlockGetter)levelReader, blockPos.m_7494_());
            }
            return true;
        }
        return false;
    }
}

