/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.MagnetBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MovingMetalBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.FallingBlockEntityAccessor;
import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MagnetBlockEntity
extends BlockEntity {
    public int age = 0;
    private float prevRangeVisuality;
    private float rangeVisuality;
    private int extenderIngots = 0;
    private int retracterIngots = 0;
    private static final int MAXIMUM_BLOCKS_PUSHED = 27;
    private boolean locallyActive;

    public MagnetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.MAGNET.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, MagnetBlockEntity entity) {
        entity.prevRangeVisuality = entity.rangeVisuality;
        ++entity.age;
        if (level.f_46443_) {
            if (entity.showRangeBox(AlexsCaves.PROXY.getClientSidePlayer())) {
                if (entity.rangeVisuality < 1.0f) {
                    entity.rangeVisuality += 0.2f;
                }
            } else if (entity.rangeVisuality > 0.0f) {
                entity.rangeVisuality -= 0.2f;
            }
            entity.locallyActive = false;
            if (((Boolean)state.m_61143_((Property)MagnetBlock.POWERED)).booleanValue()) {
                entity.locallyActive = true;
            }
            if (entity.locallyActive && !entity.m_58901_()) {
                AlexsCaves.PROXY.playWorldSound((Object)entity, (byte)4);
            }
        } else {
            Direction direction = entity.getDirection();
            if (((Boolean)state.m_61143_((Property)MagnetBlock.POWERED)).booleanValue()) {
                int distance = entity.getEffectiveRange();
                for (int i = 1; i <= distance; ++i) {
                    BlockPos checkMetalAt = blockPos.m_5484_(direction, i);
                    BlockState metalState = level.m_8055_(checkMetalAt);
                    if (!metalState.m_204336_(ACTagRegistry.MAGNETIC_BLOCKS)) continue;
                    ArrayList<BlockPos> gathered = new ArrayList<BlockPos>();
                    entity.gatherAttachedBlocks(checkMetalAt, gathered);
                    if (gathered.isEmpty()) continue;
                    ArrayList<MovingBlockData> allData = new ArrayList<MovingBlockData>();
                    for (BlockPos pos : gathered) {
                        BlockState moveState = level.m_8055_(pos);
                        BlockEntity te = level.m_7702_(pos);
                        BlockPos offset = pos.m_121996_((Vec3i)checkMetalAt);
                        MovingBlockData data = new MovingBlockData(moveState, moveState.m_60808_((BlockGetter)level, pos), offset, te == null ? null : te.m_187482_());
                        level.m_46747_(pos);
                        allData.add(data);
                    }
                    gathered.sort((blockPos1, blockPos2) -> MagnetBlockEntity.sortGatheredBlocks(level, blockPos1, blockPos2));
                    for (BlockPos pos : gathered) {
                        level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    }
                    MovingMetalBlockEntity metalBlockEntity = (MovingMetalBlockEntity)((EntityType)ACEntityRegistry.MOVING_METAL_BLOCK.get()).m_20615_(level);
                    metalBlockEntity.m_20219_(Vec3.m_82512_((Vec3i)checkMetalAt));
                    metalBlockEntity.setAllBlockData(MovingMetalBlockEntity.createTagFromData(allData));
                    metalBlockEntity.setPlacementCooldown(1);
                    level.m_7967_((Entity)metalBlockEntity);
                }
            }
        }
        if (((Boolean)state.m_61143_((Property)MagnetBlock.POWERED)).booleanValue()) {
            for (Entity entity1 : level.m_6443_(Entity.class, entity.getRangeBB(entity.getEffectiveRange(), false), EntitySelector.f_20408_)) {
                if (!MagnetUtil.isPulledByMagnets(entity1) && !(entity1 instanceof MovingMetalBlockEntity)) continue;
                entity.pushEntity(entity1);
            }
            if (level.f_46443_ && level.f_46441_.m_188501_() < 0.1f) {
                Direction dir = (Direction)state.m_61143_((Property)MagnetBlock.FACING);
                Vec3 blockVec = Vec3.m_82512_((Vec3i)entity.m_58899_());
                Vec3 edgeVec = blockVec.m_231075_(dir, (double)((float)entity.getEffectiveRange() - 1.5f));
                if (entity.isAzure()) {
                    directionVec = edgeVec.m_82520_((double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
                    level.m_7106_((ParticleOptions)ACParticleRegistry.AZURE_MAGNETIC_FLOW.get(), blockVec.f_82479_, blockVec.f_82480_, blockVec.f_82481_, directionVec.f_82479_, directionVec.f_82480_, directionVec.f_82481_);
                } else {
                    blockVec = blockVec.m_231075_(dir, 2.0);
                    edgeVec = edgeVec.m_231075_(dir, 2.0);
                    directionVec = edgeVec.m_82520_((double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
                    level.m_7106_((ParticleOptions)ACParticleRegistry.SCARLET_MAGNETIC_FLOW.get(), directionVec.f_82479_, directionVec.f_82480_, directionVec.f_82481_, blockVec.f_82479_, blockVec.f_82480_, blockVec.f_82481_);
                }
            }
        }
    }

    private static int sortGatheredBlocks(Level level, BlockPos blockPos1, BlockPos blockPos2) {
        BlockState blockState1 = level.m_8055_(blockPos1);
        BlockState blockState2 = level.m_8055_(blockPos2);
        int order = blockState1.m_204336_(ACTagRegistry.MAGNET_REMOVES_LAST) || blockState2.m_204336_(ACTagRegistry.MAGNET_REMOVES_LAST) ? 1 : -1;
        return order * Integer.compare(blockPos1.m_123342_(), blockPos2.m_123342_());
    }

    private void pushEntity(Entity entity) {
        Vec3 pull;
        float strength = 0.2f;
        Vec3 prev = entity.m_20184_();
        Vec3 blockVec = Vec3.m_82512_((Vec3i)this.m_58899_());
        Vec3 vec3 = pull = this.isAzure() ? entity.m_20182_().m_82546_(blockVec) : blockVec.m_82546_(entity.m_20182_());
        if (pull.m_82553_() > 1.0) {
            pull = pull.m_82541_();
        }
        if (entity instanceof MovingMetalBlockEntity) {
            MovingMetalBlockEntity metalBlockEntity = (MovingMetalBlockEntity)entity;
            double distance = Math.sqrt(entity.m_20238_(blockVec));
            strength = 0.04f;
            if (this.isAzure()) {
                float f = Math.max((float)this.getEffectiveRange() - 1.0f, 1.0f);
                float f1 = (float)((double)f - (distance + 1.0)) / f;
                strength *= Math.max(f1, 0.0f);
            } else if (distance <= 1.0) {
                strength = 0.0f;
            }
            metalBlockEntity.setPlacementCooldown(2);
        }
        if (entity instanceof FallingBlockEntityAccessor) {
            FallingBlockEntityAccessor fallingBlockEntity = (FallingBlockEntityAccessor)entity;
            fallingBlockEntity.setFallBlockingTime();
            strength = 0.04f;
            entity.m_20256_(prev.m_82542_(0.5, 0.5, 0.5));
        }
        if (entity instanceof LivingEntity) {
            strength = 0.2f;
            if (Math.abs(pull.f_82479_) > Math.abs(pull.f_82480_) && Math.abs(pull.f_82479_) > Math.abs(pull.f_82481_)) {
                pull = new Vec3(pull.f_82479_, 0.0, 0.0);
            }
            if (Math.abs(pull.f_82480_) > Math.abs(pull.f_82479_) && Math.abs(pull.f_82480_) > Math.abs(pull.f_82481_)) {
                pull = new Vec3(0.0, pull.f_82480_, 0.0);
            }
            if (Math.abs(pull.f_82481_) > Math.abs(pull.f_82479_) && Math.abs(pull.f_82481_) > Math.abs(pull.f_82480_)) {
                pull = new Vec3(0.0, 0.0, pull.f_82481_);
            }
            entity.f_19789_ = 0.0f;
        }
        if (!MagnetUtil.isEntityOnMovingMetal(entity)) {
            entity.m_20256_(entity.m_20184_().m_82520_((double)strength * pull.f_82479_, (double)strength * pull.f_82480_, (double)strength * pull.f_82481_));
        }
    }

    public void gatherAttachedBlocks(BlockPos pos, List<BlockPos> list) {
        if (list.size() < 27 && !list.contains(pos)) {
            list.add(pos);
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.m_121945_(dir);
                if (this.m_58899_().equals((Object)offset) || !this.canMove(pos, offset)) continue;
                this.gatherAttachedBlocks(offset, list);
            }
        }
    }

    public void m_7651_() {
        AlexsCaves.PROXY.clearSoundCacheFor(this);
        super.m_7651_();
    }

    public boolean canMove(BlockPos from, BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState other = this.f_58857_.m_8055_(from);
        if (state.m_60795_() || state.m_204336_(ACTagRegistry.UNMOVEABLE)) {
            return false;
        }
        if (state.m_204336_(ACTagRegistry.MAGNETIC_BLOCKS)) {
            return true;
        }
        if (state.isStickyBlock()) {
            return state.canStickTo(other);
        }
        return other.isStickyBlock();
    }

    public Direction getDirection() {
        if (this.m_58900_().m_60734_() instanceof MagnetBlock) {
            return (Direction)this.m_58900_().m_61143_((Property)MagnetBlock.FACING);
        }
        return Direction.UP;
    }

    public boolean isLocallyActive() {
        return this.locallyActive;
    }

    public AABB getRangeBB(double effectiveRange, boolean includeMagnet) {
        AABB blockAABB = AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)(includeMagnet ? this.m_58899_() : this.m_58899_().m_121945_(this.getDirection()))));
        double i = effectiveRange - 1.0;
        switch (this.getDirection()) {
            case UP: {
                return blockAABB.m_165893_(blockAABB.f_82292_ + i);
            }
            case DOWN: {
                return blockAABB.m_165887_(blockAABB.f_82289_ - i);
            }
            case EAST: {
                return blockAABB.m_165891_(blockAABB.f_82291_ + i);
            }
            case WEST: {
                return blockAABB.m_165880_(blockAABB.f_82288_ - i);
            }
            case SOUTH: {
                return blockAABB.m_165895_(blockAABB.f_82293_ + i);
            }
            case NORTH: {
                return blockAABB.m_165889_(blockAABB.f_82290_ - i);
            }
        }
        return blockAABB;
    }

    public boolean isAzure() {
        return this.m_58900_().m_60734_() == ACBlockRegistry.AZURE_MAGNET.get();
    }

    public int getEffectiveRange() {
        int rangeModifier = this.extenderIngots - this.retracterIngots;
        int total = Mth.m_14045_((int)(5 + rangeModifier), (int)1, (int)64);
        return this.isAzure() ? total : total + 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return this.getRangeBB(this.getEffectiveRange() + 2, true);
    }

    public boolean canAddRange() {
        int rangeModifier = this.extenderIngots - this.retracterIngots;
        return 5 + rangeModifier < 64 && this.extenderIngots + this.retracterIngots < 64;
    }

    public boolean canRemoveRange() {
        int rangeModifier = this.extenderIngots - this.retracterIngots;
        return 5 + rangeModifier > 1 && this.extenderIngots + this.retracterIngots < 64;
    }

    public void increaseRange(int by) {
        if (by > 0) {
            this.extenderIngots += by;
        } else {
            this.retracterIngots -= by;
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.extenderIngots = tag.m_128451_("ExtenderIngots");
        this.retracterIngots = tag.m_128451_("RetractorIngots");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("ExtenderIngots", this.extenderIngots);
        tag.m_128405_("RetractorIngots", this.retracterIngots);
    }

    public float getRangeVisuality(float partialTicks) {
        return this.prevRangeVisuality + (this.rangeVisuality - this.prevRangeVisuality) * partialTicks;
    }

    public boolean showRangeBox(Player entity) {
        return entity != null && (this.isExtenderItem(entity.m_21205_()) || this.isExtenderItem(entity.m_21206_()) || this.isRetracterItem(entity.m_21205_()) || this.isRetracterItem(entity.m_21206_()));
    }

    public boolean isExtenderItem(ItemStack stack) {
        return this.isAzure() ? stack.m_150930_((Item)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get()) : stack.m_150930_((Item)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get());
    }

    public boolean isRetracterItem(ItemStack stack) {
        return this.isAzure() ? stack.m_150930_((Item)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get()) : stack.m_150930_((Item)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get());
    }

    public void dropIngots(boolean azure) {
        ItemEntity itemEntity;
        Vec3 vec = Vec3.m_82512_((Vec3i)this.m_58899_());
        if (this.extenderIngots > 0) {
            ItemStack extenderIngot = new ItemStack(azure ? (ItemLike)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get() : (ItemLike)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get(), this.extenderIngots);
            itemEntity = new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, extenderIngot);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
        if (this.retracterIngots > 0) {
            ItemStack retractorIngot = new ItemStack(azure ? (ItemLike)ACItemRegistry.SCARLET_NEODYMIUM_INGOT.get() : (ItemLike)ACItemRegistry.AZURE_NEODYMIUM_INGOT.get(), this.retracterIngots);
            itemEntity = new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, retractorIngot);
            itemEntity.m_32060_();
            this.f_58857_.m_7967_((Entity)itemEntity);
        }
    }
}

