/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ConversionCrucibleBlockEntity;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.item.BiomeTreatItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ConversionCrucibleBlock
extends BaseEntityBlock {
    private static final VoxelShape INSIDE = ConversionCrucibleBlock.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)ConversionCrucibleBlock.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[]{ConversionCrucibleBlock.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)16.0), ConversionCrucibleBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape ABOVE = Block.m_49796_((double)0.0, (double)16.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    private static final VoxelShape SUCK = Shapes.m_83110_((VoxelShape)INSIDE, (VoxelShape)ABOVE);

    public ConversionCrucibleBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_60999_().m_60913_(5.0f, 12.0f).m_60918_(SoundType.f_56743_));
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos pos) {
        return INSIDE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return ConversionCrucibleBlock.m_152132_(p_152182_, (BlockEntityType)((BlockEntityType)ACBlockEntityRegistry.CONVERSION_CRUCIBLE.get()), ConversionCrucibleBlockEntity::tick);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ConversionCrucibleBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack playerItem = player.m_21120_(handIn);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ConversionCrucibleBlockEntity) {
            ConversionCrucibleBlockEntity crucible = (ConversionCrucibleBlockEntity)blockEntity;
            if (!player.m_6144_()) {
                if (crucible.getConvertingToBiome() != null) {
                    if (crucible.getWantItem().m_41619_()) {
                        crucible.rerollWantedItem();
                        crucible.markUpdated();
                    } else if (!crucible.getWantItem().m_41619_() && crucible.getWantItem().m_150930_(playerItem.m_41720_())) {
                        if (!worldIn.f_46443_) {
                            ItemStack copy = playerItem.m_41777_();
                            copy.m_41764_(1);
                            crucible.consumeItem(copy);
                            if (!player.m_150110_().f_35937_) {
                                playerItem.m_41774_(1);
                            }
                            crucible.markUpdated();
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.PASS;
                }
                if (playerItem.m_150930_((Item)ACItemRegistry.BIOME_TREAT.get()) && BiomeTreatItem.getCaveBiome(playerItem) != null) {
                    if (!worldIn.f_46443_) {
                        crucible.setConvertingToBiome(BiomeTreatItem.getCaveBiome(playerItem));
                        crucible.setFilledLevel(1);
                        crucible.rerollWantedItem();
                        crucible.markUpdated();
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public static VoxelShape getSuckShape() {
        return SUCK;
    }
}

