/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.blockentity;

import com.github.alexmodguy.alexscaves.client.model.SirenLightModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.block.SirenLightBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.SirenLightBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SirenLightBlockRenderer<T extends SirenLightBlockEntity>
implements BlockEntityRenderer<T> {
    private static final SirenLightModel MODEL = new SirenLightModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/siren_light.png");
    private static final ResourceLocation COLOR_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/siren_light_color.png");

    public SirenLightBlockRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
    }

    public void render(T light, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        poseStack.m_85836_();
        BlockState state = light.m_58900_();
        Direction dir = (Direction)state.m_61143_((Property)SirenLightBlock.FACING);
        if (dir == Direction.UP) {
            poseStack.m_252880_(0.5f, 1.5f, 0.5f);
        } else if (dir == Direction.DOWN) {
            poseStack.m_252880_(0.5f, -0.5f, 0.5f);
        } else if (dir == Direction.NORTH) {
            poseStack.m_85837_(0.5, 0.5, -0.5);
        } else if (dir == Direction.EAST) {
            poseStack.m_252880_(1.5f, 0.5f, 0.5f);
        } else if (dir == Direction.SOUTH) {
            poseStack.m_85837_(0.5, 0.5, 1.5);
        } else if (dir == Direction.WEST) {
            poseStack.m_252880_(-0.5f, 0.5f, 0.5f);
        }
        poseStack.m_252781_(dir.m_122424_().m_253075_());
        int color = ((SirenLightBlockEntity)((Object)light)).getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float rotation = ((SirenLightBlockEntity)((Object)light)).getSirenRotation(partialTicks);
        MODEL.m_6973_(null, rotation, 0.0f, 0.0f, 0.0f, 0.0f);
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE)), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        float f = ((SirenLightBlockEntity)((Object)light)).getOnProgress(partialTicks);
        if (f > 0.0f) {
            float length = f * 1.25f;
            float width = f * f * 0.5f;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 1.125f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation + 90.0f));
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getNucleeperLights());
            SirenLightBlockRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f, r, g, b);
            Matrix4f matrix4f2 = posestack$pose.m_252922_();
            Matrix3f matrix3f2 = posestack$pose.m_252943_();
            poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
            SirenLightBlockRenderer.shineOriginVertex(lightConsumer, matrix4f2, matrix3f2, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineRightCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f, r, g, b);
            SirenLightBlockRenderer.shineLeftCornerVertex(lightConsumer, matrix4f2, matrix3f2, length, width, 0.0f, 0.0f, r, g, b);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        MODEL.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)COLOR_TEXTURE)), (Boolean)state.m_61143_((Property)SirenLightBlock.POWERED) != false ? 240 : combinedLightIn, combinedOverlayIn, r, g, b, 1.0f);
        poseStack.m_85849_();
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset, float r, float g, float b) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset, float r, float g, float b) {
        p_114215_.m_252986_(p_114216_, -ACMath.HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_85950_(r, g, b, 0.0f).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset, float r, float g, float b) {
        p_114224_.m_252986_(p_114225_, ACMath.HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_85950_(r, g, b, 0.0f).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public int m_142163_() {
        return 128;
    }
}

