/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.render.entity.TremorzillaRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class TremorzillaSteamParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final int tremorzillaId;
    private final Vec3 inMouthOffset;

    protected TremorzillaSteamParticle(ClientLevel level, double x, double y, double z, int tremorzillaId, SpriteSet sprites) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.f_172258_ = 0.96f;
        this.f_172259_ = true;
        this.sprites = sprites;
        this.f_107663_ *= 1.0f + this.f_107223_.m_188501_() * 3.0f;
        this.f_107225_ = 40 + this.f_107223_.m_188503_(10);
        this.m_108339_(sprites);
        this.f_107219_ = true;
        this.tremorzillaId = tremorzillaId;
        this.inMouthOffset = new Vec3(this.f_107223_.m_188499_() ? (double)0.9f : (double)-0.9f, (double)(0.7f + this.f_107223_.m_188501_() * 0.3f), (double)(this.f_107223_.m_188501_() * 2.0f - 1.2f));
        Vec3 vec3 = this.getInMouthPos(1.0f);
        this.m_107264_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107226_ = -0.05f - this.f_107223_.m_188501_() * 0.05f;
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        float f = (float)this.f_107224_ / (float)this.f_107225_;
        this.m_107271_(1.0f - f);
    }

    public Vec3 getInMouthPos(float partialTick) {
        Entity entity;
        if (this.tremorzillaId != -1 && (entity = this.f_107208_.m_6815_(this.tremorzillaId)) instanceof TremorzillaEntity) {
            TremorzillaEntity entity2 = (TremorzillaEntity)entity;
            Vec3 mouthPos = TremorzillaRenderer.getMouthPositionFor(this.tremorzillaId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82549_(this.inMouthOffset).m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                return new Vec3(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
            }
        }
        return Vec3.f_82478_;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TremorzillaSteamParticle particle = new TremorzillaSteamParticle(worldIn, x, y, z, (int)xSpeed, this.spriteSet);
            float color = 0.2f * worldIn.f_46441_.m_188501_() + 0.6f;
            particle.m_107253_(color, color, color);
            return particle;
        }
    }
}

