/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.ProtonParticle;
import com.github.alexmodguy.alexscaves.client.render.entity.TremorzillaRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class TremorzillaProtonParticle
extends ProtonParticle {
    private static final ResourceLocation CENTER_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/tremorzilla_proton.png");
    private final int tremorzillaId;
    private final float initialXRot;
    private final float initialYRot;

    protected TremorzillaProtonParticle(ClientLevel world, double x, double y, double z, int entityId) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107225_ = 20;
        this.orbitOffset = new Vec3(0.0, 0.0, (double)(1.0f + this.f_107223_.m_188501_() * 0.2f));
        this.orbitSpeed = 10.0f;
        this.tremorzillaId = entityId;
        this.setInMouthPos(1.0f);
        this.m_107264_(this.orbitX, this.orbitY, this.orbitZ);
        this.initialXRot = this.f_107223_.m_188501_() * 180.0f;
        this.initialYRot = this.f_107223_.m_188501_() * 180.0f;
    }

    @Override
    public ResourceLocation getTexture() {
        return CENTER_TEXTURE;
    }

    @Override
    public float getTrailHeight() {
        return 0.5f;
    }

    @Override
    public void m_5989_() {
        this.setInMouthPos(1.0f);
        super.m_5989_();
        float fadeIn = 0.8f * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_ * 0.5f), (float)0.0f, (float)1.0f);
        this.trailA = fadeIn * fadeOut;
    }

    @Override
    public float getAlpha() {
        return this.f_107224_ < 2 ? 0.0f : 1.0f;
    }

    @Override
    public Vec3 getOrbitPosition(float angle) {
        Vec3 center = new Vec3(this.orbitX, this.orbitY, this.orbitZ);
        Vec3 add = this.orbitOffset.m_82490_(this.orbitDistance).m_82524_((float)Math.toRadians(this.initialYRot)).m_82496_((float)Math.toRadians(this.initialXRot));
        float rot = angle * (this.reverseOrbit ? -this.orbitSpeed : this.orbitSpeed) * ((float)Math.PI / 180);
        switch (this.orbitAxis) {
            case 0: {
                add = add.m_82496_(rot);
                break;
            }
            case 1: {
                add = add.m_82524_(rot);
                break;
            }
            case 2: {
                add = add.m_82535_(rot);
            }
        }
        return center.m_82549_(add);
    }

    public void setInMouthPos(float partialTick) {
        Entity entity;
        if (this.tremorzillaId != -1 && (entity = this.f_107208_.m_6815_(this.tremorzillaId)) instanceof TremorzillaEntity) {
            TremorzillaEntity entity2 = (TremorzillaEntity)entity;
            Vec3 mouthPos = TremorzillaRenderer.getMouthPositionFor(this.tremorzillaId);
            if (mouthPos != null) {
                Vec3 translate = mouthPos.m_82524_((float)(Math.PI - (double)(entity2.f_20883_ * ((float)Math.PI / 180))));
                Vec3 newOrbit = new Vec3(entity2.m_20185_() + translate.f_82479_, entity2.m_20186_() + translate.f_82480_, entity2.m_20189_() + translate.f_82481_);
                this.orbitX = newOrbit.f_82479_;
                this.orbitY = newOrbit.f_82480_;
                this.orbitZ = newOrbit.f_82481_;
            }
            if (entity2.getBeamProgress(1.0f) <= 0.0f) {
                this.m_107274_();
            }
        }
    }

    public static class TectonicFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TremorzillaProtonParticle particle = new TremorzillaProtonParticle(worldIn, x, y, z, (int)xSpeed);
            particle.m_107253_(1.0f, 0.85f, 0.15f);
            particle.trailR = 1.0f;
            particle.trailG = 0.85f;
            particle.trailB = 0.15f;
            return particle;
        }
    }

    public static class RetroFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TremorzillaProtonParticle particle = new TremorzillaProtonParticle(worldIn, x, y, z, (int)xSpeed);
            particle.m_107253_(0.5f, 0.2f, 1.0f);
            particle.trailR = 0.5f;
            particle.trailG = 0.2f;
            particle.trailB = 1.0f;
            return particle;
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TremorzillaProtonParticle particle = new TremorzillaProtonParticle(worldIn, x, y, z, (int)xSpeed);
            particle.m_107253_(0.0f, 1.0f, 0.0f);
            particle.trailR = 0.0f;
            particle.trailG = 1.0f;
            particle.trailB = 0.0f;
            return particle;
        }
    }
}

