/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.GammaroachEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class GammaroachModel
extends AdvancedEntityModel<GammaroachEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox bodyThing2;
    private final AdvancedModelBox bodyThing;
    private final AdvancedModelBox ltail;
    private final AdvancedModelBox rtail;
    private final AdvancedModelBox mtail;
    private final AdvancedModelBox carapace;
    private final AdvancedModelBox head;
    private final AdvancedModelBox lantennae;
    private final AdvancedModelBox antenna1Thing;
    private final AdvancedModelBox rantennae;
    private final AdvancedModelBox atenna2Thing;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox cube_r5;
    private final AdvancedModelBox rleg2;
    private final AdvancedModelBox rleg3;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox lleg2;
    private final AdvancedModelBox lleg3;
    private final ModelAnimator animator;

    public GammaroachModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 14.5f, 0.0f);
        this.body.setTextureOffset(33, 22).addBox(0.0f, -6.5f, 2.0f, 0.0f, 5.0f, 11.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-5.0f, -2.5f, -6.0f, 10.0f, 5.0f, 19.0f, 0.0f, false);
        this.bodyThing2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bodyThing2.setRotationPoint(-5.0f, -2.5f, 7.5f);
        this.body.addChild((BasicModelPart)this.bodyThing2);
        this.setRotateAngle(this.bodyThing2, 0.0f, 0.0f, -0.7854f);
        this.bodyThing2.setTextureOffset(22, 36).addBox(0.0f, -4.0f, -5.5f, 0.0f, 5.0f, 11.0f, 0.0f, true);
        this.bodyThing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bodyThing.setRotationPoint(5.0f, -2.5f, 7.5f);
        this.body.addChild((BasicModelPart)this.bodyThing);
        this.setRotateAngle(this.bodyThing, 0.0f, 0.0f, 0.7854f);
        this.bodyThing.setTextureOffset(22, 36).addBox(0.0f, -4.0f, -5.5f, 0.0f, 5.0f, 11.0f, 0.0f, false);
        this.ltail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.ltail.setRotationPoint(3.5f, 1.5f, 13.0f);
        this.body.addChild((BasicModelPart)this.ltail);
        this.ltail.setTextureOffset(39, 24).addBox(-3.5f, 0.0f, 0.0f, 8.0f, 0.0f, 4.0f, 0.0f, false);
        this.rtail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rtail.setRotationPoint(-3.5f, 1.5f, 13.0f);
        this.body.addChild((BasicModelPart)this.rtail);
        this.rtail.setTextureOffset(39, 24).addBox(-4.5f, 0.0f, 0.0f, 8.0f, 0.0f, 4.0f, 0.0f, true);
        this.mtail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.mtail.setRotationPoint(0.0f, 0.5f, 13.0f);
        this.body.addChild((BasicModelPart)this.mtail);
        this.mtail.setTextureOffset(30, 7).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 0.0f, 9.0f, 0.0f, false);
        this.carapace = new AdvancedModelBox((AdvancedEntityModel)this);
        this.carapace.setRotationPoint(0.0f, -2.5f, -6.0f);
        this.body.addChild((BasicModelPart)this.carapace);
        this.carapace.setTextureOffset(0, 41).addBox(0.0f, -4.0f, -2.5f, 0.0f, 5.0f, 11.0f, 0.0f, false);
        this.carapace.setTextureOffset(0, 33).addBox(-6.0f, -1.0f, -0.5f, 12.0f, 5.0f, 9.0f, 0.0f, false);
        this.carapace.setTextureOffset(6, 8).addBox(4.0f, -3.0f, -0.5f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.carapace.setTextureOffset(0, 6).addBox(-6.0f, -3.0f, -0.5f, 2.0f, 2.0f, 2.0f, 0.0f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 2.0f, 0.5f);
        this.carapace.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(42, 38).addBox(-3.5f, -1.5f, -4.0f, 7.0f, 4.0f, 4.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(-3.0f, 0.0f, -3.5f, 6.0f, 3.0f, 3.0f, 0.0f, false);
        this.lantennae = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lantennae.setRotationPoint(2.5f, 0.75f, -3.0f);
        this.head.addChild((BasicModelPart)this.lantennae);
        this.antenna1Thing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.antenna1Thing.setRotationPoint(-0.5f, 0.0f, 0.0f);
        this.lantennae.addChild((BasicModelPart)this.antenna1Thing);
        this.setRotateAngle(this.antenna1Thing, 0.0f, 0.0f, -0.7854f);
        this.antenna1Thing.setTextureOffset(0, 24).addBox(-2.0f, 0.0f, -7.5f, 17.0f, 0.0f, 9.0f, 0.0f, false);
        this.rantennae = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rantennae.setRotationPoint(-2.5f, 0.75f, -3.0f);
        this.head.addChild((BasicModelPart)this.rantennae);
        this.atenna2Thing = new AdvancedModelBox((AdvancedEntityModel)this);
        this.atenna2Thing.setRotationPoint(0.5f, 0.0f, 0.0f);
        this.rantennae.addChild((BasicModelPart)this.atenna2Thing);
        this.setRotateAngle(this.atenna2Thing, 0.0f, 0.0f, 0.7854f);
        this.atenna2Thing.setTextureOffset(0, 24).addBox(-15.0f, 0.0f, -7.5f, 17.0f, 0.0f, 9.0f, 0.0f, true);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-1.5f, 2.0f, -5.0f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.cube_r5 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r5.setRotationPoint(0.0f, 0.5f, 0.0f);
        this.rleg.addChild((BasicModelPart)this.cube_r5);
        this.setRotateAngle(this.cube_r5, 0.0f, -0.7854f, 0.0f);
        this.cube_r5.setTextureOffset(58, 12).addBox(-11.5f, -1.0f, 0.0f, 12.0f, 8.0f, 0.0f, 0.0f, true);
        this.rleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg2.setRotationPoint(-1.5f, 2.0f, -1.5f);
        this.body.addChild((BasicModelPart)this.rleg2);
        this.rleg2.setTextureOffset(49, 0).addBox(-11.5f, -3.5f, 0.0f, 12.0f, 11.0f, 0.0f, 0.0f, true);
        this.rleg3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg3.setRotationPoint(-1.5f, 2.0f, 2.0f);
        this.body.addChild((BasicModelPart)this.rleg3);
        this.setRotateAngle(this.rleg3, 0.0f, 0.7854f, 0.0f);
        this.rleg3.setTextureOffset(0, 57).addBox(-20.5f, -3.5f, 0.0f, 21.0f, 11.0f, 0.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(1.5f, 2.0f, -5.0f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.setRotateAngle(this.lleg, 0.0f, 0.7854f, 0.0f);
        this.lleg.setTextureOffset(58, 12).addBox(-0.5f, -0.5f, 0.0f, 12.0f, 8.0f, 0.0f, 0.0f, false);
        this.lleg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg2.setRotationPoint(1.5f, 2.0f, -1.5f);
        this.body.addChild((BasicModelPart)this.lleg2);
        this.lleg2.setTextureOffset(49, 0).addBox(-0.5f, -3.5f, 0.0f, 12.0f, 11.0f, 0.0f, 0.0f, false);
        this.lleg3 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg3.setRotationPoint(1.5f, 2.0f, 2.0f);
        this.body.addChild((BasicModelPart)this.lleg3);
        this.setRotateAngle(this.lleg3, 0.0f, -0.7854f, 0.0f);
        this.lleg3.setTextureOffset(0, 57).addBox(-0.5f, -3.5f, 0.0f, 21.0f, 11.0f, 0.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.head, (Object)this.lantennae, (Object)this.rantennae, (Object)this.carapace, (Object)this.mtail, (Object)this.rtail, (Object)this.ltail, (Object)this.bodyThing2, (Object)this.bodyThing, (Object)this.antenna1Thing, (Object)this.atenna2Thing, (Object[])new AdvancedModelBox[]{this.cube_r5, this.rleg, this.rleg2, this.rleg3, this.lleg, this.lleg2, this.lleg3});
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(GammaroachEntity.ANIMATION_SPRAY);
        this.animator.startKeyframe(10);
        this.animator.rotate(this.body, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.carapace, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.lleg, (float)Math.toRadians(-10.0), (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.rleg, (float)Math.toRadians(-10.0), (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.lleg2, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.rleg2, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.lleg3, (float)Math.toRadians(-10.0), (float)Math.toRadians(40.0), (float)Math.toRadians(-20.0));
        this.animator.rotate(this.rleg3, (float)Math.toRadians(-10.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(20.0));
        this.animator.move(this.lleg, 0.0f, -2.0f, 1.0f);
        this.animator.move(this.rleg, 0.0f, -2.0f, 1.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(20);
        this.animator.resetKeyframe(10);
        this.animator.endKeyframe();
        this.animator.setAnimation(GammaroachEntity.ANIMATION_RAM);
        this.animator.startKeyframe(5);
        this.animator.move(this.body, 0.0f, 0.0f, 6.0f);
        this.animator.rotate(this.lleg, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.rleg, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.lleg2, 0.0f, (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.rleg2, 0.0f, (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.lleg3, 0.0f, (float)Math.toRadians(50.0), 0.0f);
        this.animator.rotate(this.rleg3, 0.0f, (float)Math.toRadians(-50.0), 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(2);
        this.animator.startKeyframe(3);
        this.animator.move(this.body, 0.0f, 0.0f, -9.0f);
        this.animator.move(this.carapace, 0.0f, 1.0f, -2.0f);
        this.animator.rotate(this.carapace, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(20.0), 0.0f, 0.0f);
        this.animator.rotate(this.lleg, 0.0f, (float)Math.toRadians(-30.0), 0.0f);
        this.animator.rotate(this.rleg, 0.0f, (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.lleg2, 0.0f, (float)Math.toRadians(-40.0), 0.0f);
        this.animator.rotate(this.rleg2, 0.0f, (float)Math.toRadians(40.0), 0.0f);
        this.animator.rotate(this.lleg3, 0.0f, (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.rleg3, 0.0f, (float)Math.toRadians(20.0), 0.0f);
        this.animator.rotate(this.rantennae, (float)Math.toRadians(-80.0), 0.0f, 0.0f);
        this.animator.rotate(this.lantennae, (float)Math.toRadians(-80.0), 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(5);
        this.animator.resetKeyframe(10);
    }

    private void setupAnimForAnimation(GammaroachEntity entity, Animation animation, float limbSwing, float limbSwingAmount, float ageInTicks) {
        float partialTick = ageInTicks - (float)entity.f_19797_;
        if (animation == GammaroachEntity.ANIMATION_SPRAY) {
            float animationIntensity = ACMath.cullAnimationTick(entity.getAnimationTick(), 3.0f, animation, partialTick, 10, 30);
            this.swing(this.body, 1.0f, 0.2f, false, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.body, 1.0f, 0.2f, false, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.lleg, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.lleg, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.rleg, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.rleg, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.lleg2, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.lleg2, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.rleg2, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.rleg2, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.lleg3, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.lleg3, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
            this.swing(this.rleg3, 1.0f, 0.2f, true, 0.0f, 0.0f, ageInTicks, animationIntensity);
            this.walk(this.rleg3, 1.0f, 0.2f, true, 1.0f, 0.0f, ageInTicks, animationIntensity);
        }
    }

    public void setupAnim(GammaroachEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float walkSpeed = 1.0f;
        float walkDegree = 0.9f;
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float deathAmount = ((float)entity.f_20919_ + partialTicks) / 20.0f;
        this.progressRotationPrev(this.rantennae, limbSwingAmount, (float)Math.toRadians(-80.0), 0.0f, (float)Math.toRadians(20.0), 1.0f);
        this.progressRotationPrev(this.lantennae, limbSwingAmount, (float)Math.toRadians(-80.0), 0.0f, (float)Math.toRadians(-20.0), 1.0f);
        if ((double)entity.f_20919_ > 0.0) {
            limbSwing = ageInTicks;
            limbSwingAmount = 1.0f;
        }
        this.progressPositionPrev(this.body, deathAmount * deathAmount, 0.0f, 16.0f, 0.0f, 1.0f);
        this.walk(this.head, 0.1f, 0.1f, true, 0.0f, -0.1f, ageInTicks, 1.0f);
        this.walk(this.rantennae, 0.1f, 0.15f, true, 1.0f, -0.3f, ageInTicks, 1.0f);
        this.walk(this.lantennae, 0.1f, 0.15f, true, 1.0f, -0.3f, ageInTicks, 1.0f);
        this.walk(this.mtail, 0.1f, 0.05f, true, 2.0f, -0.05f, ageInTicks, 1.0f);
        this.swing(this.rtail, 0.1f, 0.05f, true, 3.0f, -0.05f, ageInTicks, 1.0f);
        this.swing(this.ltail, 0.1f, 0.05f, false, 3.0f, -0.05f, ageInTicks, 1.0f);
        float offset = 0.0f;
        float offsetleft = 2.0f;
        float offsetUp = 0.3f;
        this.swing(this.rleg, walkSpeed, walkDegree * 1.2f, false, offset, -0.3f, limbSwing, limbSwingAmount);
        this.flap(this.rleg, walkSpeed, walkDegree * 0.3f, false, offset - 1.5f, offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.lleg, walkSpeed, -walkDegree * 1.2f, false, offset + offsetleft, 0.3f, limbSwing, limbSwingAmount);
        this.flap(this.lleg, walkSpeed, walkDegree * 0.3f, false, offset + offsetleft + 1.5f, -offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.rleg2, walkSpeed, -walkDegree, false, (offset += 1.5f) + offsetleft, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.rleg2, walkSpeed, walkDegree * 0.3f, false, offset + offsetleft - 1.5f, offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.lleg2, walkSpeed, walkDegree, false, offset, 0.0f, limbSwing, limbSwingAmount);
        this.flap(this.lleg2, walkSpeed, walkDegree * 0.3f, false, offset - 1.5f, -offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.rleg3, walkSpeed, walkDegree * 0.5f, false, offset += 1.5f, -0.1f, limbSwing, limbSwingAmount);
        this.flap(this.rleg3, walkSpeed, walkDegree * 0.3f, false, offset - 1.5f, offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.lleg3, walkSpeed, -walkDegree * 0.5f, false, offset + offsetleft, 0.1f, limbSwing, limbSwingAmount);
        this.flap(this.lleg3, walkSpeed, walkDegree * 0.3f, false, offset + offsetleft - 1.5f, -offsetUp, limbSwing, limbSwingAmount);
        this.swing(this.body, walkSpeed, walkDegree * 0.2f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.bob(this.body, walkSpeed, walkDegree * -3.0f, true, limbSwing, limbSwingAmount);
        if (entity.getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            this.setupAnimForAnimation(entity, entity.getAnimation(), limbSwing, limbSwingAmount, ageInTicks);
        }
    }
}

