/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CaveBookModel
extends AdvancedEntityModel {
    private final AdvancedModelBox root;
    private final AdvancedModelBox spine;
    private final AdvancedModelBox lcover;
    private final AdvancedModelBox lpageStack;
    private final AdvancedModelBox rcover;
    private final AdvancedModelBox rpageStack;
    private final AdvancedModelBox rpageOpen;
    private final AdvancedModelBox page_flip;

    public CaveBookModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.spine = new AdvancedModelBox((AdvancedEntityModel)this);
        this.spine.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.spine);
        this.spine.setTextureOffset(0, 49).addBox(-1.0f, -0.5f, -8.0f, 2.0f, 1.0f, 16.0f, 0.0f, false);
        this.lcover = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lcover.setRotationPoint(0.5f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.lcover);
        this.lcover.setTextureOffset(0, 32).addBox(-0.5f, -1.0f, -8.0f, 13.0f, 1.0f, 16.0f, 0.0f, false);
        this.lpageStack = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lpageStack.setRotationPoint(0.5f, 0.0f, 0.0f);
        this.lcover.addChild((BasicModelPart)this.lpageStack);
        this.lpageStack.setTextureOffset(0, 16).addBox(-1.0f, -3.0f, -7.0f, 12.0f, 2.0f, 14.0f, 0.01f, false);
        this.lpageStack.setTextureOffset(-16, 0).addBox(-1.0f, -4.0f, -8.0f, 13.0f, 1.0f, 16.0f, 0.01f, false);
        this.rcover = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rcover.setRotationPoint(-0.5f, 0.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.rcover);
        this.rcover.setTextureOffset(0, 32).addBox(-12.5f, -1.0f, -8.0f, 13.0f, 1.0f, 16.0f, 0.0f, true);
        this.rpageStack = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rpageStack.setRotationPoint(-0.5f, 0.0f, 0.0f);
        this.rcover.addChild((BasicModelPart)this.rpageStack);
        this.rpageStack.setTextureOffset(0, 16).addBox(-11.0f, -3.0f, -7.0f, 12.0f, 2.0f, 14.0f, 0.0f, true);
        this.rpageStack.setTextureOffset(-16, 0).addBox(-12.0f, -4.0f, -8.0f, 13.0f, 1.0f, 16.0f, 0.0f, true);
        this.rpageOpen = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rpageOpen.setRotationPoint(0.5f, -3.0f, 0.0f);
        this.rcover.addChild((BasicModelPart)this.rpageOpen);
        this.setRotateAngle(this.rpageOpen, 0.0f, 0.0f, 0.1309f);
        this.page_flip = new AdvancedModelBox((AdvancedEntityModel)this);
        this.page_flip.setRotationPoint(0.0f, -3.0f, 0.0f);
        this.root.addChild((BasicModelPart)this.page_flip);
        this.setRotateAngle(this.page_flip, 0.0f, 0.0f, -1.5708f);
        this.page_flip.setTextureOffset(-16, 0).addBox(0.0f, -1.0f, -8.0f, 13.0f, 1.0f, 16.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public void m_6973_(Entity entity, float openAmount, float pageAngle, float pageUp, float bookRotateX, float bookRotateY) {
        this.resetToDefaultPose();
        float close = 1.0f - openAmount;
        this.progressRotationPrev(this.lcover, close, 0.0f, 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.progressRotationPrev(this.rcover, close, 0.0f, 0.0f, (float)Math.toRadians(90.0), 1.0f);
        this.progressPositionPrev(this.lcover, close, 1.75f, 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rcover, close, -1.75f, 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.root, close, 0.0f, 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.root.rotateAngleX += (float)Math.toRadians(bookRotateX);
        this.root.rotateAngleZ += (float)Math.toRadians(bookRotateY);
        this.lcover.setScale(1.0f + close * 0.01f, 1.0f + close * 0.01f, 1.0f + close * 0.01f);
        if (openAmount < 1.0f) {
            this.page_flip.showModel = false;
        } else {
            this.page_flip.showModel = true;
            this.page_flip.rotateAngleZ = this.lcover.rotateAngleZ - pageAngle;
        }
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.rcover, (Object)this.lcover, (Object)this.rpageOpen, (Object)this.rpageStack, (Object)this.lpageStack, (Object)this.page_flip, (Object)this.spine);
    }

    public void mouseOver(float mouseLeanX, float mouseLeanY, float ageInTicks, float pageFlipAmount, boolean canGoLeft, boolean canGoRight) {
        float turnWobble = (float)((Math.sin(ageInTicks * 0.2f) + 1.0) * 0.5) * (1.0f - pageFlipAmount);
        if (pageFlipAmount == 0.0f) {
            float clamped;
            if (mouseLeanX < -0.75f && canGoLeft) {
                clamped = Mth.m_14036_((float)((mouseLeanX + 0.75f) * 8.0f), (float)-1.0f, (float)0.0f);
                this.page_flip.rotateAngleZ = this.lcover.rotateAngleZ + clamped * (float)Math.toRadians(turnWobble * 15.0f);
            }
            if (mouseLeanX > 0.75f && canGoRight) {
                clamped = Mth.m_14036_((float)((mouseLeanX - 0.75f) * 8.0f), (float)0.0f, (float)1.0f);
                this.page_flip.rotateAngleZ = this.lcover.rotateAngleZ + (float)Math.PI + clamped * (float)Math.toRadians(turnWobble * 15.0f);
            }
        }
    }

    public void translateToPage(PoseStack poseStack, int kind) {
        this.root.translateAndRotate(poseStack);
        if (kind == 0) {
            this.lcover.translateAndRotate(poseStack);
            this.lpageStack.translateAndRotate(poseStack);
        } else if (kind == 1) {
            this.rcover.translateAndRotate(poseStack);
            this.rpageStack.translateAndRotate(poseStack);
        } else if (kind == 2) {
            this.page_flip.translateAndRotate(poseStack);
        }
    }
}

