/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.argonauts.common.network.messages;

import com.google.common.primitives.UnsignedInteger;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.argonauts.api.guild.Guild;
import earth.terrarium.argonauts.api.guild.GuildApi;
import earth.terrarium.argonauts.api.party.Party;
import earth.terrarium.argonauts.api.party.PartyApi;
import earth.terrarium.argonauts.common.handlers.base.members.Group;
import earth.terrarium.argonauts.common.handlers.base.members.Member;
import earth.terrarium.argonauts.common.handlers.chat.ChatHandler;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessage;
import earth.terrarium.argonauts.common.handlers.chat.ChatMessageType;
import earth.terrarium.argonauts.common.handlers.chat.MessageChannel;
import earth.terrarium.argonauts.common.network.NetworkHandler;
import earth.terrarium.argonauts.common.network.messages.ClientboundReceiveMessagePacket;
import java.time.Instant;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record ServerboundChatWindowPacket(String message, ChatMessageType type) implements Packet<ServerboundChatWindowPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("argonauts", "send_chat_message");
    public static final PacketHandler<ServerboundChatWindowPacket> HANDLER = new Handler();

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<ServerboundChatWindowPacket> getHandler() {
        return HANDLER;
    }

    public static void sendMessage(ServerPlayer player, Group<?, ?> group, String message, MessageChannel channel) {
        ChatMessage chatMessage = new ChatMessage(player.m_36316_(), message, Instant.now());
        UnsignedInteger id = channel.add(chatMessage);
        ClientboundReceiveMessagePacket packet = new ClientboundReceiveMessagePacket(id, chatMessage);
        for (Member member : group.members()) {
            ServerPlayer memberPlayer = player.f_8924_.m_6846_().m_11259_(member.profile().getId());
            if (memberPlayer == null) continue;
            if (member.getState().isPermanentMember()) {
                Component messageComponent = CommonUtils.serverTranslatable((String)"text.argonauts.chat_message", (Object[])new Object[]{group.displayName().m_6879_().m_130940_(group.color()), ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)player).f_240886_(), message});
                memberPlayer.m_5661_(messageComponent, false);
            }
            if (!NetworkHandler.CHANNEL.canSendPlayerPackets((Player)memberPlayer)) continue;
            NetworkHandler.CHANNEL.sendToPlayer((Packet)packet, (Player)memberPlayer);
        }
    }

    private static class Handler
    implements PacketHandler<ServerboundChatWindowPacket> {
        private Handler() {
        }

        public void encode(ServerboundChatWindowPacket message, FriendlyByteBuf buffer) {
            buffer.m_130072_(message.message, 512);
            buffer.m_130068_((Enum)message.type);
        }

        public ServerboundChatWindowPacket decode(FriendlyByteBuf buffer) {
            return new ServerboundChatWindowPacket(buffer.m_130136_(512), (ChatMessageType)buffer.m_130066_(ChatMessageType.class));
        }

        public PacketContext handle(ServerboundChatWindowPacket message) {
            return (player, level) -> {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                switch (message.type()) {
                    case PARTY: {
                        Party party = PartyApi.API.get((Player)serverPlayer);
                        if (party == null) {
                            return;
                        }
                        MessageChannel channel = ChatHandler.getChannel(party, message.type());
                        ServerboundChatWindowPacket.sendMessage(serverPlayer, party, message.message, channel);
                        break;
                    }
                    case GUILD: {
                        Guild guild = GuildApi.API.get(serverPlayer);
                        if (guild == null) {
                            return;
                        }
                        MessageChannel channel = ChatHandler.getChannel(guild, message.type());
                        ServerboundChatWindowPacket.sendMessage(serverPlayer, guild, message.message, channel);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected value: " + message.type());
                    }
                }
            };
        }
    }
}

